% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algebraNA.R
\name{sobocinski}
\alias{sobocinski}
\alias{algebraNA}
\alias{kleene}
\alias{dragonfly}
\alias{nelson}
\alias{lowerEst}
\alias{lowerBound}
\title{Modify algebra's way of computing with \code{NA} values.}
\usage{
sobocinski(algebra)

kleene(algebra)

dragonfly(algebra)

nelson(algebra)

lowerEst(algebra)

lowerBound(algebra)
}
\arguments{
\item{algebra}{the underlying algebra object to be modified -- see the \code{\link[=algebra]{algebra()}} function}
}
\value{
A list of function of the same structure as is the list returned from the \code{\link[=algebra]{algebra()}} function
}
\description{
By default, the objects created with the \code{\link[=algebra]{algebra()}} function represent a mathematical
algebra capable to work on the \eqn{[0,1]} interval. If \code{NA} appears as a value instead,
it is propagated to the result. That is, any operation with \code{NA} results in \code{NA}, by default.
This scheme of handling missing values is also known as Bochvar's. To change this default
behavior, the following functions may be applied.
}
\details{
The \code{sobocinski()}, \code{kleene()}, \code{nelson()}, \code{dragonfly()}, \code{lowerEst()} and \code{lowerBound()}
functions modify the algebra to
handle the \code{NA} in a different way than is the default. Sobocinski's algebra simply ignores \code{NA} values
whereas Kleene's algebra treats \code{NA} as "unknown value". Dragonfly approach is a combination
of Sobocinski's and Bochvar's approach, which preserves the ordering \verb{0 <= NA <= 1}
to obtain from compositions (see \code{\link[=compose]{compose()}})
the lower-estimate in the presence of missing values.

In detail, the behavior of the algebra modifiers is defined as follows:

Sobocinski's negation for \code{n} being the underlying algebra:
\tabular{ll}{
a  \tab n(a)\cr
NA \tab 0
}

Sobocinski's operation for \code{op} being one of \code{t}, \code{pt}, \code{c}, \code{pc}, \code{i}, \code{pi}, \code{s}, \code{ps}
from the underlying algebra:
\tabular{lll}{
\tab b        \tab NA\cr
a  \tab op(a, b) \tab a \cr
NA \tab b        \tab NA
}

Sobocinski's operation for \code{r} from the underlying algebra:
\tabular{lll}{
\tab b       \tab NA  \cr
a  \tab r(a, b) \tab n(a)\cr
NA \tab b       \tab NA
}

Kleene's negation is identical to \code{n} from the underlying algebra.

Kleene's operation for \code{op} being one of \code{t}, \code{pt}, \code{i}, \code{pi} from the underlying algebra:
\tabular{llll}{
\tab b        \tab NA \tab 0\cr
a  \tab op(a, b) \tab NA \tab 0\cr
NA \tab NA       \tab NA \tab 0\cr
0  \tab 0        \tab 0  \tab 0
}

Kleene's operation for \code{op} being one of \code{c}, \code{pc}, \code{s}, \code{ps} from the underlying algebra:
\tabular{llll}{
\tab b        \tab NA \tab 1\cr
a  \tab op(a, b) \tab NA \tab 1\cr
NA \tab NA       \tab NA \tab 1\cr
1  \tab 1        \tab 1  \tab 1
}

Kleene's operation for \code{r} from the underlying algebra:
\tabular{llll}{
\tab b        \tab NA \tab 1\cr
a  \tab r(a, b)  \tab NA \tab 1\cr
NA \tab NA       \tab NA \tab 1\cr
0  \tab 1        \tab 1  \tab 1
}

Dragonfly negation is identical to \code{n} from the underlying algebra.

Dragonfly operation for \code{op} being one of \code{t}, \code{pt}, \code{i}, \code{pi} from the underlying algebra:
\tabular{lllll}{
\tab b        \tab NA \tab 0 \tab 1\cr
a  \tab op(a, b) \tab NA \tab 0 \tab a\cr
NA \tab NA       \tab NA \tab 0 \tab NA\cr
0  \tab 0        \tab 0  \tab 0 \tab 0\cr
1  \tab b        \tab NA \tab 0 \tab 1
}

Dragonfly operation for \code{op} being one of \code{c}, \code{pc}, \code{s}, \code{ps} from the underlying algebra:
\tabular{lllll}{
\tab b        \tab NA \tab 0  \tab 1\cr
a  \tab op(a, b) \tab a  \tab a  \tab 1\cr
NA \tab b        \tab NA \tab NA \tab 1\cr
0  \tab b        \tab NA \tab 0  \tab 1\cr
1  \tab 1        \tab 1  \tab 1  \tab 1
}

Dragonfly operation for \code{r} from the underlying algebra:
\tabular{lllll}{
\tab b       \tab NA \tab 0    \tab 1\cr
a  \tab r(a, b) \tab NA \tab n(a) \tab 1\cr
NA \tab b       \tab 1  \tab NA   \tab 1\cr
0  \tab 1       \tab 1  \tab 1    \tab 1\cr
1  \tab b       \tab NA \tab 0    \tab 1
}

LowerEst and LowerBound algebras are equivalent to Dragonfly's algebra in
\code{t}, \code{pt}, \code{i}, \code{pi}, \code{c}, \code{pc}, \code{s}, \code{ps} operations, but differ in the
\code{r} and \code{n} operations. \code{n} is equal to the Sobocinski's negation for both
LowerEst and LowerBound algebras.

LowerEst's operation for \code{r} from the underlying algebra:

\tabular{lllll}{
\tab b       \tab NA \tab 0    \tab 1\cr
a  \tab r(a, b) \tab NA \tab n(a) \tab 1\cr
NA \tab b       \tab NA \tab 0    \tab 1\cr
0  \tab 1       \tab 1  \tab 1    \tab 1\cr
1  \tab b       \tab NA \tab 0    \tab 1
}

LowerBound's operation for \code{r} from the underlying algebra:

\tabular{lllll}{
\tab b       \tab NA \tab 0    \tab 1\cr
a  \tab r(a, b) \tab NA \tab n(a) \tab 1\cr
NA \tab 1       \tab 1  \tab 0    \tab 1\cr
0  \tab 1       \tab 1  \tab 1    \tab 1\cr
1  \tab b       \tab NA \tab 0    \tab 1
}
}
\examples{
a <- algebra('lukas')
b <- sobocinski(a)

a$t(0.3, NA)  # NA
b$t(0.3, NA)  # 0.3

}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
