% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{s4_generics}
\alias{s4_generics}
\alias{parameter_info}
\alias{component_info}
\alias{covariate_info}
\alias{component_names}
\alias{get_model}
\alias{is_f_sampled}
\alias{get_stanfit}
\alias{postproc}
\alias{contains_postproc}
\alias{clear_postproc}
\alias{num_paramsets}
\alias{num_evalpoints}
\alias{num_components}
\title{S4 generics for lgpfit, lgpmodel, and other objects}
\usage{
parameter_info(object, digits)

component_info(object)

covariate_info(object)

component_names(object)

get_model(object)

is_f_sampled(object)

get_stanfit(object)

postproc(object, ...)

contains_postproc(object)

clear_postproc(object)

num_paramsets(object)

num_evalpoints(object)

num_components(object)
}
\arguments{
\item{object}{object for which to apply the generic}

\item{digits}{number of digits to show}

\item{...}{additional optional arguments to pass}
}
\value{
\itemize{
   \item \code{parameter_info} returns a data frame with
   one row for each parameter and columns
   for parameter name, parameter bounds, and the assigned prior
   \item \code{component_info} returns a data frame with one row for
   each model component, and columns encoding information about
   model components
   \item \code{covariate_info} returns a list with names
   \code{continuous} and \code{categorical}, with information about
   both continuous and categorical covariates
   \item \code{component_names} returns a character vector with
   component names
   \item \code{get_model} for \linkS4class{lgpfit} objects
   returns an \linkS4class{lgpmodel}
   \item \code{is_f_sampled} returns a logical value
   \item \code{get_stanfit} returns a \code{stanfit} (rstan)
   \item \code{postproc} applies postprocessing and returns an
   updated \linkS4class{lgpfit}
   \item \code{clear_postproc} removes postprocessing information and
   returns an updated \linkS4class{lgpfit}
   \item \code{num_paramsets}, \code{num_evalpoints} and
   \code{num_components} return an integer


}
}
\description{
S4 generics for lgpfit, lgpmodel, and other objects
}
\section{Functions}{
\itemize{
\item \code{parameter_info()}: Get parameter information (priors etc.).

\item \code{component_info()}: Get component information.

\item \code{covariate_info()}: Get covariate information.

\item \code{component_names()}: Get component names.

\item \code{get_model()}: Get \linkS4class{lgpmodel} object.

\item \code{is_f_sampled()}: Determine if signal f is sampled or marginalized.

\item \code{get_stanfit()}: Extract stanfit object.

\item \code{postproc()}: Perform postprocessing.

\item \code{contains_postproc()}: Determine if object contains postprocessing
information.

\item \code{clear_postproc()}: Clear postprocessing information (to reduce
size of object).

\item \code{num_paramsets()}: Get number of parameter sets.

\item \code{num_evalpoints()}: Get number of points where posterior is evaluated.

\item \code{num_components()}: Get number of model components.

}}
\seealso{
To find out which methods have been implemented for which classes,
see \linkS4class{lgpfit}, \linkS4class{lgpmodel},
\linkS4class{Prediction} and \linkS4class{GaussianPrediction}.
}
