% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-fit_model.R
\name{sample_model}
\alias{sample_model}
\alias{optimize_model}
\title{Fitting a model}
\usage{
sample_model(
  model,
  verbose = TRUE,
  quiet = FALSE,
  skip_postproc = is_f_sampled(model),
  ...
)

optimize_model(model, ...)
}
\arguments{
\item{model}{An object of class \linkS4class{lgpmodel}.}

\item{verbose}{Can messages be printed?}

\item{quiet}{Should all output messages be suppressed? You need to set
also \code{refresh=0} if you want to suppress also the progress update
messages from \code{\link[rstan]{sampling}}.}

\item{skip_postproc}{Should all postprocessing be skipped? If this is
\code{TRUE}, the returned \linkS4class{lgpfit} object will likely be
much smaller (if \code{sample_f=FALSE}).}

\item{...}{Optional arguments passed to
\code{\link[rstan]{sampling}} or \code{\link[rstan]{optimizing}}.}
}
\value{
\itemize{
  \item \code{sample_model} returns an object of class \linkS4class{lgpfit}
  containing the parameter draws, the original \code{model} object,
  and possible postprocessing results. See documentation of
  \linkS4class{lgpfit} for more information.
  \item \code{optimize_model} directly returns the list returned by
\code{\link[rstan]{optimizing}}. See its documentation for more information.
}
}
\description{
\itemize{
  \item \code{sample_model} takes an \linkS4class{lgpmodel}
  object and fits it using \code{\link[rstan]{sampling}}.
  \item \code{optimize_model} takes an \linkS4class{lgpmodel}
  object and fits it using \code{\link[rstan]{optimizing}}.
}
}
\seealso{
Other main functions: 
\code{\link{create_model}()},
\code{\link{draw_pred}()},
\code{\link{get_draws}()},
\code{\link{lgp}()},
\code{\link{pred}()},
\code{\link{prior_pred}()}
}
\concept{main functions}
