% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hypergeometric.R
\name{likhyper}
\alias{likhyper}
\title{Hypergeometric Log Likelihood Function}
\usage{
likhyper(x, m, n, k, log = TRUE)
}
\arguments{
\item{x}{vector of quantiles representing the number of white balls
    drawn without replacement from an urn which contains both black and
    white balls.}

\item{m}{the number of white balls in the urn.}

\item{n}{the number of black balls in the urn.}

\item{k}{the number of balls drawn from the urn.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the hypergeometric density
given the data where m, n, and k can be held constant or if vector were given
vector will be returned.
}
\description{
The log likelihood of a hypergeometric density with data, x, m, n and k
parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likhyper(x = rhyper(nn = 2, m = 3, n = 4, k = 2),
        m = 3, n = 4, k = 2)
}
