% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_events.R
\name{plot_events}
\alias{plot_events}
\title{Plot Events as Bar Plots}
\usage{
plot_events(
  e,
  group.col = NULL,
  groups = NULL,
  data.cols = NULL,
  dim = NULL,
  byrow = TRUE,
  main = NULL,
  xlabs = character(),
  ylabs = character(),
  xlim = NULL,
  ylim = NULL,
  xticks = NULL,
  yticks = NULL,
  xtick.labels = NULL,
  ytick.labels = NULL,
  plot.grid = FALSE,
  sigfigs = c(3, 3),
  col = NULL,
  border = par("fg"),
  lty = par("lty"),
  lwd = par("lwd"),
  xpd = FALSE,
  mar = c(2.1, 2.75, 1.5, 0.5),
  oma = c(2, 2, 2, 2),
  ...
)
}
\arguments{
\item{e}{An event table.}

\item{group.col}{Name or index of column defining the event grouping for plotting. If \code{NULL}, the events are treated as one group. Group \code{NA} is not plotted.}

\item{groups}{Vector of values from \code{group.col} specifying which groups to plot. If \code{NULL}, all groups are plotted by order of first appearance in \code{group.col}.}

\item{data.cols}{Names or indices of columns to plot, given as a list of character or numeric vectors. If multiple columns are specified, their bars are stacked together in one plot. Names are interpreted as regular expressions (\code{\link{regex}}) matching full column names. If \code{NULL}, all columns not named \code{from}, \code{to}, or \code{group.col} are each plotted individually in order of appearance.}

\item{dim}{The row and column dimensions of the grid. If \code{NULL}, the grid is column groups (rows) by event groups (columns) if \code{byrow = TRUE}, and event groups (rows) by column groups (columns) if \code{byrow = FALSE}.}

\item{byrow}{Plots are added by column group, then bin group. If \code{TRUE}, plots are added by rows, rather than columns, to the grid.}

\item{main}{Titles for each plot. If \code{NULL}, plots are titled by the column names, pasted together with separator " + ". Set \code{main = NA} to not title the plots.}

\item{xlabs, ylabs}{Labels arranged at equal intervals along the bottom and left side of the plot grid. These are drawn in the outer margins of the figure, so \code{oma[1]} and \code{oma[2]} must be non-zero.}

\item{xlim, ylim}{Limits for the x and y axes of all plots. If \code{NULL}, limits are set to the range of the data and the y limits extended as needed to include 0.}

\item{xticks, yticks}{The positions of x and y tick marks for all plots. If \code{NULL}, only the min and max x and y are ticked (and 0 as needed for y). If \code{\link{axTicks}}, that function will be used to calculate R default tick mark positions. If \code{NA}, no ticks are drawn.}

\item{xtick.labels, ytick.labels}{The labels for the x and y tick marks, coerced to character vectors and recycled as necessary. If \code{NULL}, the positions of the ticks are used as the labels, formatted with \code{sigfigs}. If \code{NA}, the tick marks are not labeled.}

\item{plot.grid}{If \code{TRUE}, a lined horizontal grid is plotted at the yticks.}

\item{sigfigs}{The maximum significant figures of the x and y axis labels.}

\item{col}{Color(s) for the bars in each plot. If \code{NA}, bars are transparent. If \code{NULL}, a grey palette is used.}

\item{border}{Color(s) for bar borders in each plot. If \code{NA}, borders are omitted.}

\item{lty}{Line type(s) for bar borders in each plot.}

\item{lwd}{Line width(s) for bar borders in each plot.}

\item{xpd}{Logical value or \code{NA}. If \code{FALSE}, all plotting is clipped to the plot region, if \code{TRUE}, all plotting is clipped to the figure region, and if \code{NA}, all plotting is clipped to the device region.}

\item{mar}{Numerical vector of the form c(bottom, left, top, right) giving the size of the inner margins of each plot in lines of text.}

\item{oma}{Numeric vector of the form c(bottom, left, top, right) giving the size of the outer figure margins in lines of text.}

\item{...}{Additional arguments passed to \code{\link{plot}}.}
}
\description{
Plots an event table as a grid of bar plots.
}
\details{
Given a grouping variable for the rows of the event table (e.g., groups of bins of different sizes used in \code{\link{sample_events}}), and groups of columns to plot, bar plots are drawn in a grid for each combination of event and column groups. In each plot, the specified event table columns are plotted together as stacked bars. Negative and positive values are stacked separately from the \code{y = 0} baseline. Events with \code{NA} are not shown, differentiating them from zero-valued events which are drawn as thin black lines. Point events are drawn as thin vertical lines. Overlapping events are drawn as overlapping bars, so it is best to use \code{\link{sample_events}} with non-overlapping bins to flatten the data before plotting.
}
\examples{
e <- events(from = c(0, 10, 15, 25), to = c(10, 20, 25, 40), length = c(10, 10, 10, 15),
            x = c(1, 2, 1, 1), f = c('a', 'b', 'a', 'a'))
bins <- seq_events(event_coverage(e), c(8, 4, 2, 1))
e.bins <- sample_events(e, bins, list(sum, c('x', 'length')), scaled.cols = 'length')
plot_events(e.bins, group.col = 'group')
}
\seealso{
\code{\link{seq_events}} for generating groups of sequential bins, \code{\link{sample_events}} to populate groups of bins with event data.
}
