% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{check_cost_defined}
\alias{check_cost_defined}
\title{Check whether there's missing characters in the cost matrix.}
\usage{
check_cost_defined(data, cost_mat, delim = "")
}
\arguments{
\item{data}{DataFrame to be computed.}

\item{cost_mat}{Cost matrix to be checked.}

\item{delim}{The delimiter separating atomic symbols.}
}
\value{
A string vector containing the missing characters, empty indicating there's no missing characters.
}
\description{
Check whether there's missing characters in the cost matrix and return the missing characters.
}
\examples{
df <- as.data.frame(rbind(a=c("a_bc_d","d_bc_a"),b=c("b_bc_d","d_bc_a")))
cost.mat <- data.frame()
chars.not.found <- check_cost_defined(df, cost.mat, "_")
}
