% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listArray.R
\name{listArray}
\alias{listArray}
\alias{listArray.default}
\title{listArray}
\usage{
listArray(x, ...)

\method{listArray}{default}(x, use.names = TRUE, ignore = NULL, env = FALSE, ...)
}
\arguments{
\item{x}{vector, array or list}

\item{...}{further arguments given to \code{new.env} if an environment is used}

\item{use.names}{logical: if the names from \code{x} or indices should be used (default: \code{TRUE})}

\item{ignore}{values to ignore for the listArray object}

\item{env}{logical: if the listArray creates a list or an environment (default: \code{FALSE})}
}
\value{
a \code{listArray} object
}
\description{
Creates either an empty \code{listArray} object or a \code{listArray} object from a vector, array or list.
See also \code{vignette("listArray")}.
}
\examples{
# empty listArray
l <- listArray()
# listArray from a numerical vector
v <- 1:5
l <- listArray(v)
# listArray from a text vector
v <- letters[1:5]
l <- listArray(v)
#' # listArray from a matrix
m <- matrix(1:9, 3, 3)
l <- listArray(m)
#' # listArray from a list
v <- as.list(1:5)
l <- listArray(v)
}
