% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmForc_subset.R
\name{subset_forcs}
\alias{subset_forcs}
\title{Subset a list of Forecast objects by index.}
\usage{
subset_forcs(forcs, index)
}
\arguments{
\item{forcs}{List of Forecast objects.}

\item{index}{Numeric or logical value or vector.}
}
\value{
List of subsetted Forecast objects.
}
\description{
General function for subsetting all forecasts in a list of Forecast objects.
}
\examples{

forc1_1h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-05", "2011-03-10")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.27, 3.36, 4.78, 5.45, 5.12),
  realized = c(4.96, 4.17, 4.26, 4.99, 5.38),
  h_ahead = 1
)

forc2_1h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-22", "2011-03-27")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.01, 3.89, 3.31, 4.33, 4.61),
  realized = c(4.96, 4.17, 4.26, 4.99, 5.38),
  h_ahead = 1
)

forcs <- list(forc1_1h, forc2_1h)

subset_forcs(forcs, 1:4)

subset_forcs(forcs, origin(forc1_1h) >= as.Date("2010-12-31"))

}
