% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmForc_transform.R
\name{transform_bytime}
\alias{transform_bytime}
\title{Convert a list of h_ahead format Forecast objects to a list of time format
Forecast objects.}
\usage{
transform_bytime(forcs, slot = "future")
}
\arguments{
\item{forcs}{List of Forecast objects.}

\item{slot}{Character representing whether the list of Forecasts will be converted
to a list of Forecasts with homogenous origin or future values. Must be either
"origin" or "future".}
}
\value{
List of Forecast objects in time format.
}
\description{
Given a list of forecasts with different h_ahead values, converts all forecasts
in the list to time format. Transforms a list of Forecast objects that have
homogenous h_ahead values to a list of Forecast objects with homogenous origin
or future values.
}
\examples{

# The following forecasts are in h_ahead format. All forecasts come from the 
# same source (forc1) and have the same origin values. However, the forecasts
# are for different periods ahead.

forc1_1h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-22")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31", "2011-03-31")),
  forecast = c(4.27, 3.36, 4.78, 5.45),
  realized = c(4.96, 4.17, 4.26, 4.99),
  h_ahead = 1
)

forc1_2h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-22")),
  future = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(3.77, 3.82, 4.53, 4.89),
  realized = c(4.17, 4.26, 4.99, 5.33),
  h_ahead = 2
)

forc1_3h <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-05-14", "2010-07-22", "2010-12-22")),
  future = as.Date(c("2010-12-31", "2011-03-31", "2011-06-30", "2011-09-30")),
  forecast = c(3.52, 4.22, 5.03, 5.78),
  realized = c(4.26, 4.99, 5.33, 5.21),
  h_ahead = 3
)

forcs <- list(forc1_1h, forc1_2h, forc1_3h)

transform_bytime(forcs, slot = "origin")

}
