% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmds.R, R/package.R
\docType{package}
\name{lmds}
\alias{lmds}
\alias{lmds-package}
\title{Landmark MDS}
\usage{
lmds(x, ndim = 3, distance_method = c("euclidean", "pearson",
  "spearman", "cosine", "manhattan"), landmark_method = c("sample"),
  num_landmarks = 500)
}
\arguments{
\item{x}{A matrix, optionally sparse.}

\item{ndim}{The number of dimensions}

\item{distance_method}{The distance metric to use. Options are "euclidean" (default), "pearson", "spearman", "cosine", "manhattan".}

\item{landmark_method}{The landmark selection method to use. Options are "sample" (default).}

\item{num_landmarks}{The number of landmarks to use,}
}
\value{
The dimensionality reduction in the form of a \code{nrow(x)} by \code{ndim} matrix.
}
\description{
A fast dimensionality reduction method scaleable to large numbers of samples.
Landmark Multi-Dimensional Scaling (LMDS) is an extension of classical 'Torgerson MDS',
but rather than calculating a complete distance matrix between all pairs of samples,
only the distances between a set of landmarks and the samples are calculated.

A fast dimensionality reduction method scaleable to large numbers of samples.
Landmark Multi-Dimensional Scaling (LMDS) is an extension of classical Torgerson MDS´,
but rather than calculating a complete distance matrix between all pairs of samples,
only the distances between a set of landmarks and the samples are calculated.
}
\examples{
library(Matrix)
x <- Matrix::rsparsematrix(1000, 1000, .01)
lmds(x, ndim = 3)
}
