% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_available.R
\name{exec_available}
\alias{exec_available}
\title{Check executable availability and version}
\usage{
exec_available(exec, version = NULL, error = FALSE)
}
\arguments{
\item{exec}{executable identifier, a single character.
Use one of these values:
\itemize{
\item \code{chrome}: 'Google Chrome' executable
\item \code{firefox}: 'Mozilla Firefox' executable
\item \code{libreoffice}: 'LibreOffice' executable
\item \code{node}: 'node.js' executable
\item \code{npm}: 'npm' executable
\item \code{python}: 'python' executable
\item \code{pip}: 'pip' executable
\item \code{excel}: 'Microsoft Excel' executable
\item \code{word}: 'Microsoft Word' executable
\item \code{powerpoint}: 'Microsoft PowerPoint' executable
}}

\item{version}{required version of executable}

\item{error}{if \code{TRUE}, executes an error action if executable
with the required version is not found.}
}
\value{
a logical indicating whether the executable is available.
}
\description{
determine whether an executable is
currently available on the user machine (optionally checking for
a specific or greater version).
}
\examples{
if (exec_available("python")) {
  cat("python", as.character(exec_version("python")), "is available!\n")
}
if(exec_available("python", "3.9")) {
  cat("required version of python is available!\n")
}
if (exec_available("pip")) {
  cat("pip", as.character(exec_version("pip")), "is available!\n")
}
if (exec_available("pip", "19.3")) {
  cat("pip", as.character(exec_version("pip")), "is available!\n")
}
if (exec_available("chrome")) {
  cat("chrome", as.character(exec_version("chrome")), "is available!\n")
}
if (exec_available("firefox")) {
  cat("firefox", as.character(exec_version("firefox")), "is available!\n")
}
if (exec_available("node")) {
  cat("node.js", as.character(exec_version("node")), "is available!\n")
}
if (exec_available("npm")) {
  cat("npm", as.character(exec_version("npm")), "is available!\n")
}
if (exec_available("npm", version = "10.13.0")) {
  cat("npm", as.character(exec_version("npm")), "is available!\n")
}
if (exec_available("excel")) {
  cat("excel", as.character(exec_version("excel")), "is available!\n")
}
if (exec_available("word")) {
  cat("word", as.character(exec_version("word")), "is available!\n")
}
if (exec_available("powerpoint")) {
  cat("powerpoint", as.character(exec_version("powerpoint")), "is available!\n")
}
}
