% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgsolve.R
\name{lgsolve}
\alias{lgsolve}
\title{Equilibrium locations of location game}
\usage{
lgsolve(edgeMatrix, coordMatrix, nPlayers = 2, demandLoc)
}
\arguments{
\item{edgeMatrix}{A square matrix consisting of zeros and ones. Has to be zero on the diagonals}

\item{coordMatrix}{A data frame containing the x and y coordinates of each network vertex}

\item{nPlayers}{Number of players in the location game. Default is set to 2, which is the only number of players supported right now.}

\item{demandLoc}{A vector containing the demand or profit at each vertex of the network}
}
\value{
A list with two components. A matrix with zeros and ones, where a one symbolizes a equilibrium location. The row index denotes the location of player 1,
and the column index the location chosen by player 2. The second entry is a summary of all
equilibrium locations and the payoffs for player 1 and 2.
}
\description{
Function finds the equilibrium locations of a location game, similar to a hotelling game. Clients choose
the location closest to them.
}
\examples{
edgeMatrix <- matrix(0, nrow = 6, ncol = 6)
edgeMatrix[,1] <- c(0,1,0,0,0,0)
edgeMatrix[,2] <- c(1,0,1,0,1,0)
edgeMatrix[,3] <- c(0,1,0,0,0,0)
edgeMatrix[,4] <- c(0,0,0,0,1,0)
edgeMatrix[,5] <- c(0,1,0,1,0,1)
edgeMatrix[,6] <- c(0,0,0,0,1,0)
coordMatrix <- matrix(c(0,3,0,2,0,1,1,3,1,2,1,1), nrow = 6, ncol = 2, byrow = TRUE)
demandLoc <- c(100, 100, 100, 100, 100, 100)
lgsolve(edgeMatrix, coordMatrix, 2, demandLoc)
}
