% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify_gia_data}
\alias{fortify_gia_data}
\title{Put GIA measurements into a dplyr format}
\usage{
fortify_gia_data(data)
}
\arguments{
\item{data}{data frame of GIA measurements
\describe{
 \item{well}{one of "IRBC", "uRBC", "RPMI", or "comb"}
 \item{dose_A}{dose of A in mg/mL}
 \item{dose_B}{dose of B in mg/mL}
 \item{exp(X)(Y)rep(Z)}{ where X = 1 or 2, Y = a or b, and Z = 1, 2, or 3}
 }}
}
\value{
long data frame with columns well, dose_A, dose_B, plate, exp_num (experiment number), plate (a or b), rep_num (repetition number), gia_mean, and average iRBC and uRBC
}
\description{
Put GIA measurements into a dplyr format
}
\examples{
df <- loewesadditivity::rh5_ama1ron2
df$dose_A <- df$RH5
df$dose_B <- df$AMA1RON2
fortified_df <- fortify_gia_data(df)
head(fortified_df)
}
