% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormalSum.R
\name{estimateSumLognormalSample}
\alias{estimateSumLognormalSample}
\alias{estimateSumLognormalSampleExpScale}
\alias{estimateSumLognormal}
\title{Estimate the parameters of the lognormal approximation to the sum}
\usage{
estimateSumLognormalSample(
  mu,
  sigma,
  resLog,
  effAcf = computeEffectiveAutoCorr(resLog),
  isGapFilled = logical(0),
  na.rm = TRUE
)

estimateSumLognormalSampleExpScale(mean, sigmaOrig, ...)

estimateSumLognormal(
  mu,
  sigma,
  effAcf = c(),
  corr = Diagonal(length(mu)),
  corrLength = if (inherits(corr, "ddiMatrix")) 0 else nTerm,
  sigmaSum = numeric(0),
  isStopOnNoTerm = FALSE,
  na.rm = isStopOnNoTerm
)
}
\arguments{
\item{mu}{numeric vector of center parameters of terms at log scale}

\item{sigma}{numeric vector of scale parameter of terms at log scale}

\item{resLog}{time series of model-residuals at log scale 
to estimate correlation}

\item{effAcf}{numeric vector of effective autocorrelation
This overrides arguments \code{corr} and \code{corrLength}}

\item{isGapFilled}{logical vector whether entry is gap-filled 
rather than an original measurement, see details}

\item{na.rm}{neglect terms with NA values in mu or sigma}

\item{mean}{numeric vector of expected values}

\item{sigmaOrig}{numeric vector of standard deviation at original scale}

\item{...}{further arguments passed to \code{estimateSumLognormalSample}}

\item{corr}{numeric matrix of correlations between the random variables}

\item{corrLength}{integer 
scalar: set correlation length to smaller values
to speed up computation by neglecting correlations among terms
further apart.
Set to zero to omit correlations.}

\item{sigmaSum}{numeric scalar: possibility to specify
a precomputed scale parameter instead of computing it.}

\item{isStopOnNoTerm}{if no finite estimate is provided then by
default NA is returned for the sum.
Set this to TRUE to issue an error instead.}
}
\value{
numeric vector with components \code{mu}, \code{sigma}, 
and \code{nEff},
i.e. the parameters of the lognormal distribution at log scale
and the number of effective observations.
}
\description{
Estimate the parameters of the lognormal approximation to the sum

Estimate the parameters of the lognormal approximation to the sum
}
\details{
If there are no gap-filled values, i.e. \code{all(!isGapFilled)} or
\code{!length(isGapFilled)} (the default), distribution parameters
are estimated using all the samples. Otherwise, the scale parameter
(uncertainty) is first estimated using only the non-gapfilled records.

Also use isGapFilled == TRUE for records, where sigma cannot be trusted. 
When setting sigma to missing, this is also affecting the expected value.

If there are only gap-filled records, 
assume uncertainty to be 
(before v0.1.5: the largest uncertainty of given gap-filled records.)
the mean of the given multiplicative standard deviation
}
\section{Functions}{
\itemize{
\item \code{estimateSumLognormalSample}: In addition to \code{estimateSumLognormal} take care of missing values
and estimate correlation terms.

\item \code{estimateSumLognormalSampleExpScale}: Before calling \code{estimateSumLognormalSample} estimate
lognormal parameters from value and its uncertainty given
on original scale.

\item \code{estimateSumLognormal}: Estimate the parameters of the lognormal approximation to the sum
}}

\examples{
  # distribution of the sum of two lognormally distributed random variables
  mu1 = log(110)
  mu2 = log(100)
  sigma1 = log(1.2)
  sigma2 = log(1.6)
  (coefSum <- estimateSumLognormal( 
  c(mu1,mu2), c(sigma1,sigma2) ))
  # repeat with correlation
  (coefSumCor <- estimateSumLognormal( 
  c(mu1,mu2), c(sigma1,sigma2), effAcf = c(1,0.9) ))
  # expected value is equal, but variance with correlated variables is larger
  getLognormMoments(coefSum["mu"],coefSum["sigma"])
  getLognormMoments(coefSumCor["mu"],coefSumCor["sigma"])
}
\references{
\code{Lo C (2013) WKB approximation for the sum of two 
correlated lognormal random variables.
Applied Mathematical Sciences, Hikari, Ltd., 7 , 6355-6367 
10.12988/ams.2013.39511}
}
