% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brr.R
\name{brr}
\alias{brr}
\title{Generate replicates of a dataset using Balanced Repeated Replication}
\usage{
brr(
  data,
  k = 0,
  pseudo_strata = ceiling(nrow(data)/2),
  reps = NULL,
  max_reps = 80,
  weight_cols = "none",
  id_col = 1,
  drop = TRUE
)
}
\arguments{
\item{data}{dataset}

\item{k}{deflating weight factor. \eqn{0 \leq k \leq 1}.}

\item{pseudo_strata}{number of pseudo-strata}

\item{reps}{number of replicates}

\item{max_reps}{maximum number of replicates (only functional if \code{reps = NULL})}

\item{weight_cols}{vector of weight columns}

\item{id_col}{number of column in dataset containing subject IDs. Set 0 to use the row names as ID}

\item{drop}{if \code{TRUE}, the observation that will not be part of the subsample is dropped from the dataset. Otherwise, it stays in the dataset but a new weight column is created to differentiate the selected observations}
}
\value{
a list containing all the BRR replicates of \code{data}
}
\description{
Generate replicates of a dataset using Balanced Repeated Replication
}
\note{
PISA uses the BRR Fay method with \eqn{k = 0.5}.
}
\references{
OECD (2015). Pisa Data Analysis Manual.
Adams, R., & Wu, M. (2002). PISA 2000 Technical Report. Paris: Organization for Economic Co-operation and Development (OECD).
Rust, K. F., & Rao, J. N. K. (1996). Variance estimation for complex surveys using replication techniques. Statistical methods in medical research, 5(3), 283-310.
}
\seealso{
\code{\link[=jackknife]{jackknife()}}
}
