% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/no_logger.R
\docType{class}
\name{no_log}
\alias{no_log}
\title{The nop logger}
\format{
An \code{R6} class object.
}
\description{
Record nothing, but present logger interface.
}
\section{Creating a logger}{


\code{no_logger$new(verbose=TRUE)}
\tabular{ll}{
  \code{verbose}\tab toggle verbosity
}
}

\section{Dump options}{
 

\code{$dump(file=NULL,...)}
\tabular{ll}{
\code{file}\tab Ignored. Filename or \code{\link[base]{connection}} to write output to.\cr
\code{...}\tab Ignored. extra options passed to \code{\link[utils]{write.csv}}, except
\code{row.names}, which is set to \code{FALSE}.\cr
}

No file or output is created, except a message when \code{verbose=TRUE}.
}

\section{Get data}{

\code{$logdata()} Returns empty data.frame.
}

\examples{

logfile <- tempfile(fileext=".csv")
out <- women \%L>\%
  start_log(log=no_log$new(verbose=FALSE)) \%L>\%
  identity() \%L>\%
  head() \%L>\% 
  dump_log(file=logfile, stop=TRUE)

cat(readLines(logfile),"\n") # Empty file

}
\seealso{
Other loggers: 
\code{\link{cellwise}},
\code{\link{expression_logger}},
\code{\link{filedump}},
\code{\link{simple}}
}
\concept{loggers}
