% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{expandtbl}
\alias{expandtbl}
\alias{expandfreq}
\title{Expand \code{2x2 table} into \code{data.frame}}
\usage{
expandtbl(
  ...,
  exp_name = "exp",
  exp_lvl = c("exposed", "unexposed"),
  case_name = "case",
  case_lvl = c("case", "control"),
  strata_name = "strata"
)

expandfreq(data, freq)
}
\arguments{
\item{...}{vectors}

\item{exp_name}{Name of \code{exp} Variable}

\item{exp_lvl}{Names of two categories in the order of
Exposed and non-exposed}

\item{case_name}{Name of \code{Case} variable}

\item{case_lvl}{names of two categories in the order of}

\item{strata_name}{Name of stratified variable}

\item{data}{frequency table in data.frame}

\item{freq}{name of variable for the weighted frequency}
}
\value{
data.frame
}
\description{
\code{expandtbl()} generates a data.frame based on vectors.
}
\details{
\strong{expandtbl}

uses the vectors of \code{2x2} tables and
generates a data frame of at least two columns:
exp and case.

\preformatted{expandtbl(c(100, 200, 100, 200))}

\code{Strata}

Multiple tables can be used to construct a dataset by specifying
\code{strata_name} as follow. Strata can be included
using multiple named vectors.

\preformatted{
expandtbl(
             strata1 = c(100, 200, 100, 200),
             strata2 = c(100, 200, 100, 200),
             strata3 = c(100, 200, 100, 200),
             exp_name = "exp",
             exp_lvl = c("exposed", "unexposed"),
             case_name = "case",
             case_lvl = c("case", "control"),
             strata_name = "Strata"
)
}

\code{Labels for variables}

If names or levels of variables are not specified, the followings are
applied.

\enumerate{
\item exp Name: \code{exp}
\item exp levels: \code{exposed} and \code{unexposed}
\item case Name: \code{case}
\item case levels: \code{case} and \code{control}
\item Strata Name: \code{strata}
\item Note: Strata levels are not considered as vectors must
be named.
}

\strong{expandfreq()} uses the weighted frequencies in
data.frame format and construct another data.frame
based on the frequency weight.
The name of the frequency weighted variable can be
specified by \code{freq} argument.
}
\section{Functions}{
\itemize{
\item \code{expandfreq}: \code{expandfreq()} expands a frequency-weighted table
into a data.frame.
}}

\examples{


## Asthma Example from Essential Medical Statistics
## page 160
asthma <- expandtbl(c(81, 995, 57, 867),
              exp_name = "sex",
              exp_lvl = c("woman", "man"),
              case_name = "asthma",
              case_lvl = c("yes", "no"))

\dontrun{
## label variable and dataset
asthma <- label(asthma, "Hypothetical Data of Asthma Prevalence")
asthma <- label(asthma, sex = "Man or Woman",
                           asthma = "Asthma or No Asthma")

## Checking codebook
codebook(asthma)


## simple tabulation
tab(asthma)

## cross-tabulation
tab(asthma, sex, by = asthma)
}


## Example for expanding frequency weighted data

## Example from UCLA website
## you can download the dataset here:
## https://stats.idre.ucla.edu/stat/stata/examples/icda/afterlife.dta

x <- data.frame(gender = c(1, 1, 0, 0),
                 aftlife = c(1, 0, 1, 0),
                 freq = c(435, 147, 375, 134))
y <- expandfreq(x, freq)

## check the numbers by tabulation
## tab(y, gender, by = aftlife)

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
