% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{recode}
\alias{recode}
\title{Recode a variable}
\usage{
recode(data, var, ...)
}
\arguments{
\item{data}{data.frame}

\item{var}{variable name}

\item{...}{specify in pattern: \verb{old value} / \verb{new value}.}
}
\value{
a data.frame
}
\description{
\code{recode()} changes the values of a variable.
}
\details{
It changes the values of a variable according to the old values
specified. Values that does not meet any of the conditions,
they are left unchanged.

\strong{Using colon \code{:} to indicate a range of numeric numbers}

A numeric vector can be indicated by using \code{:} in \verb{old value}.
The function automatically filters the values that meet the
range and assigns a specified new value to these.
}
\examples{

x <- recode(infert, case, 0/"No", 1/"Yes")
tab(x, case)

\dontrun{
## recode a factor
x <- recode(infert, education, "0-5yrs"/1, "6-11yrs"/2, "12+ yrs"/3)
tab(x, education)

## recode numeric vectors
x <- recode(infert, age, 21:28.9/1, 29:34.9/2, 35:44/3)
tab(x, age)

## recode NA
infert[4:20, "case"] <- NA
x <- recode(infert, case, NA/"Missing value")
tab(infert, case)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
