% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-copula.r
\name{mable.copula}
\alias{mable.copula}
\title{Maximum Approximate Bernstein Likelihood Estimate
 of Copula Density Function}
\usage{
mable.copula(
  x,
  M0 = 1,
  M,
  unif.mar = TRUE,
  pseudo.obs = c("empirical", "mable"),
  interval = NULL,
  search = TRUE,
  mar.deg = FALSE,
  high.dim = FALSE,
  controls = mable.ctrl(sig.level = 0.05),
  progress = TRUE
)
}
\arguments{
\item{x}{an \code{n x d} matrix or \code{data.frame} of multivariate sample of size \code{n}
from d-variate distribution with hyperrectangular specified by \code{interval}.}

\item{M0}{a nonnegative integer or a vector of \code{d} nonnegative integers specify
starting candidate degrees for searching optimal degrees.}

\item{M}{a positive integer or a vector of \code{d} positive integers specify
the maximum candidate or the given model degrees for the joint density.}

\item{unif.mar}{logical, whether all the marginals distributions are uniform or not. 
If not the pseudo observations will be created using \code{empirical} or \code{mable}  
marginal distributions.}

\item{pseudo.obs}{\code{"empirical"}: use empirical distribution to create pseudo,
observations, or \code{"mable"}: use mable of marginal cdfs to create pseudo observations}

\item{interval}{a vector of two endpoints or a \code{2 x d} matrix, each column containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th column is assigned as \code{extendrange(x[,i])}.
If \code{unif.mar=TRUE}, then it is \eqn{[0,1]^d}.}

\item{search}{logical, whether to search optimal degrees between \code{M0} and \code{M} 
or not but use \code{M} as the given model degrees for the joint density.}

\item{mar.deg}{logical, if TRUE (default), the optimal degrees are selected based on marginal data,
otherwise, the optimal degrees are chosen by the method of change-point. See details.}

\item{high.dim}{logical, data are high dimensional/large sample or not
if TRUE, run a slower version procedure which requires less memory}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
A list with components
\itemize{
 \item \code{m} a vector of the selected optimal degrees by the method of change-point
 \item \code{p} a vector of the mixture proportions \eqn{p(j_1, \ldots, j_d)}, arranged in the 
  column-major order of \eqn{j = (j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}.
 \item \code{mloglik}  the maximum log-likelihood at an optimal degree \code{m}
 \item \code{pval}  the p-values of change-points for choosing the optimal degrees for the 
   marginal densities
 \item \code{M} the vector \code{(m1, m2, ..., md)} at which the search of model degrees stopped.
   If \code{mar.deg=TRUE} \code{mi} is the largest candidate degree when the search stoped for 
   the \code{i}-th marginal density
 \item \code{convergence} An integer code. 0 indicates successful completion(the EM iteration is   
   convergent). 1 indicates that the iteration limit \code{maxit} had been reached in the EM iteration;
 \item if \code{unif.mar=FALSE}, \code{margin} contains objects of the results of mable fit  
      to the marginal data
}
}
\description{
Maximum Approximate Bernstein Likelihood Estimate
 of Copula Density Function
}
\details{
A \eqn{d}-variate copula density \eqn{c(u)} on \eqn{[0, 1]^d} can be approximated 
  by a mixture of \eqn{d}-variate beta densities on \eqn{[0, 1]^d}, 
  \eqn{\beta_{mj}(x) = \prod_{i=1}^d\beta_{m_i,j_i}(u_i)},
  with proportion \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}, 
  which satisfy the uniform marginal constraints, the copula (density) has   
  uniform marginal cdf (pdf). If \code{search=TRUE} and \code{mar.deg=TRUE}, then the 
  optimal degrees are \eqn{(\tilde m_1,\ldots,\tilde m_d)}, where \eqn{\tilde m_i} is 
  chosen based on marginal data of \eqn{u_i}, $\eqn{i=1,\ldots,d}. If \code{search=TRUE} 
  and \code{mar.deg=FALSE}, then the optimal degrees \eqn{(\hat m_1,\ldots,\hat m_d)}
  are chosen using a change-point method based on the joint data. 

  For large data and high dimensional density, the search for the model degrees might be 
  time-consuming. Thus patience is needed.
}
\examples{
## Simulated bivariate data from Gaussian copula
\donttest{ 
 set.seed(1)
 rho<-0.4; n<-1000
 x<-rnorm(n)
 u<-pnorm(cbind(rnorm(n, mean=rho*x, sd=sqrt(1-rho^2)),x))
 res<- mable.copula(u, M = c(3,3), search =FALSE, mar.deg=FALSE,  progress=FALSE)
 plot(res, which="density") 
}
}
\references{
Wang, T. and Guan, Z. (2019). Bernstein polynomial model for nonparametric 
      multivariate density. Statistics 53(2), 321–338.
  Guan, Z.,  Nonparametric Maximum Likelihood Estimation of Copula
}
\seealso{
\code{\link{mable}}, \code{\link{mable.mvar}}
}
\author{
Zhong Guan <zguan@iu.edu>
}
\concept{copula density estimation}
\concept{multivariate Bernstein polynomial model for copula}
\keyword{copula}
\keyword{distribution}
\keyword{multivariate}
\keyword{nonparametric}
