% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-ph-model.r
\name{mable.reg}
\alias{mable.reg}
\title{Mable fit of semiparametric regression model based on interval censored data}
\usage{
mable.reg(
  formula,
  data,
  model = c("ph", "aft", "po"),
  M,
  g = NULL,
  pi0 = NULL,
  tau = Inf,
  x0 = NULL,
  controls = mable.ctrl(),
  progress = TRUE
)
}
\arguments{
\item{formula}{regression formula. Response must be of the form \code{cbind(l, u)}.  See 'Details'.}

\item{data}{a data frame containing variables in \code{formula}.}

\item{model}{the model to fit. Current options are "\code{ph}"
(Cox PH) or "\code{aft}" (accelerated failure time model)}

\item{M}{a vector \code{(m0, m1)} specifies the set of consective integers as candidate degrees}

\item{g}{an initial guess of the regression coefficients}

\item{pi0}{Initial guess of \eqn{\pi(x_0) = F(\tau_n|x_0)}. Without right censored data, \code{pi0 = 1}. See 'Details'.}

\item{tau}{right endpoint of support \eqn{[0, \tau)} must be greater than or equal to the maximum observed time}

\item{x0}{a data frame containing working baseline covariates on the right-hand-side of \code{formula}. See 'Details'.}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit 
and other control options. Default is \code{\link{mable.ctrl}}.}

\item{progress}{if \code{TRUE} a text progressbar is displayed}
}
\value{
A 'mable_reg' class object
}
\description{
Wrapping all \code{mable} fit of regression models in one function.
Using maximum approximate Bernstein/Beta likelihood
estimation to fit semiparametric regression models: Cox ph model,
proportional odds(po) model, accelerated failure time model, and so on.
}
\details{
For "\code{ph}"  model a missing initial guess of the regression coefficients 
   \code{g} is obtained by \code{ic_sp()} of package \code{icenReg}. For "\code{aft}" model a
   missing \code{g} is imputed by the rank estimate \code{aftsrr()} of package \code{aftgee} 
   for right-censored data. For general interval censored observations, we keep the 
   right-censored but replace the finite interval with its midpoint and fit the data by 
   \code{aftsrr()} as a right-censored data.
}
\seealso{
\code{\link{mable.aft}}, \code{\link{mable.ph}}, \code{\link{mable.po}}
}
\author{
Zhong Guan <zguan@iu.edu>
}
\concept{Cox proportional hazards model}
\concept{accelerated failure time model}
\concept{interval censoring}
\keyword{distribution}
\keyword{models}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
\keyword{survival}
