% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/made.r
\name{madem.density}
\alias{madem.density}
\title{Minimum Approximate Distance Estimate of univariate Density Function 
 with given model degree(s)}
\usage{
madem.density(
  x,
  m,
  p = rep(1, prod(m + 1))/prod(m + 1),
  interval = NULL,
  method = c("qp", "em"),
  maxit = 10000,
  eps = 1e-07
)
}
\arguments{
\item{x}{an \code{n x d} matrix or \code{data.frame} of multivariate sample of size \code{n}}

\item{m}{a positive integer or a vector of \code{d} positive integers specify
the given model degrees for the joint density.}

\item{p}{initial guess of \code{p}}

\item{interval}{a vector of two endpoints or a \code{2 x d} matrix, each column containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th column is assigned as \code{c(min(x[,i]), max(x[,i]))}.}

\item{method}{method for finding minimum distance estimate. "em": EM like method;}

\item{maxit}{the maximum iterations}

\item{eps}{the criterion for convergence}
}
\value{
An invisible \code{mable} object with components
\itemize{
  \item \code{m} the given model degree(s) 
  \item \code{p} the estimated vector of mixture proportions 
      with the given optimal degree(s) \code{m}
  \item \code{interval} support/truncation interval \code{[a, b]}
  \item \code{D}  the minimum distance at degree \code{m}
 }
}
\description{
Minimum Approximate Distance Estimate of univariate Density Function 
 with given model degree(s)
}
\details{
A \eqn{d}-variate cdf \eqn{F} on a hyperrectangle \eqn{[a, b]
  =[a_1, b_1] \times \cdots \times [a_d, b_d]} can be approximated 
  by a mixture of \eqn{d}-variate beta cdfs on \eqn{[a, b]}, 
  \eqn{\beta_{mj}(x) = \prod_{i=1}^dB_{m_i,j_i}[(x_i-a_i)/(b_i-a_i)]},
  with proportion \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}. 
  With a given model degree \code{m}, the parameters \code{p}, the mixing
  proportions of the beta distribution, are calculated as the minimizer of the
  approximate \eqn{L_2} distance between the empirical distribution and 
  the Bernstein polynomial model. The quadratic programming with linear constraints
  is used to solve the problem.
}
