% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenocam.R
\name{phenocam_image_url}
\alias{phenocam_image_url}
\alias{phenocam_read_day_urls}
\alias{phenocam_read_monthly_midday_urls}
\alias{phenocam_image_url_midday}
\alias{phenocam_info}
\alias{phenocam_download}
\title{Retrieve images from Phenocam}
\usage{
phenocam_image_url(when = NULL, ...)

phenocam_read_day_urls(x = Sys.Date())

phenocam_read_monthly_midday_urls(x = Sys.Date())

phenocam_image_url_midday(x = Sys.Date())

phenocam_info()

phenocam_download(...)
}
\arguments{
\item{when}{a string to be converted into a date-time}

\item{...}{arguments passed to \code{\link[phenocamr]{download_phenocam}}}

\item{x}{a Date}
}
\description{
Phenocam contains over 70,000 images taken from MacLeish.
Photos have been taken every 30 minutes since February 2017.
}
\examples{
phenocam_image_url()
phenocam_image_url("2021-12-25 12:05:05")
\dontrun{
phenocam_read_day_urls()
}
\dontrun{
phenocam_read_monthly_midday_urls()
}
\dontrun{
phenocam_image_url_midday(Sys.Date() - 3)
phenocam_image_url_midday(Sys.Date() - 365)
}
\dontrun{
phenocam_info()
}
\dontrun{
phenocam_download()
df <- read_phenocam(file.path(tempdir(),"macleish_DB_1000_3day.csv"))
print(str(df))
}
}
\references{
\url{https://phenocam.nau.edu/webcam/sites/macleish/}
}
\seealso{
\code{\link[phenocamr]{download_phenocam}}
}
