% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{stock_returns}
\alias{stock_returns}
\title{Stock Returns Data}
\format{
A \code{data.frame} object with 1930 observations and 3 columns
The columns are defined as follows:
\describe{
 \item{\code{Date}}{The closing date at which the return was observed, as a \code{Date} object.
 These are Friday dates, ranging from January 1981 through December 2017.}
 \item{\code{AAPL}}{The simple returns of AAPL common shares, based on
 weekly (adjusted) close prices.  A value of \code{0.01} corresponds to a one percent return.
 Close prices are adjusted for splits and dividends by Quandl.}
 \item{\code{IBM}}{The simple returns of IBM common shares, based on
 weekly (adjusted) close prices.  A value of \code{0.01} corresponds to a one percent return.
 Close prices are adjusted for splits and dividends by Quandl.}
}
}
\source{
Data were collated from Quandl on August 25, 2018. This data is no longer
freely available from Quandl, but may be available directly from Nasdaq,
see:
\url{https://www.nasdaq.com/market-activity/stocks/aapl/historical}
and 
\url{https://www.nasdaq.com/market-activity/stocks/ibm/historical}.
}
\usage{
data(stock_returns)
}
\description{
Historical weekly relative returns of common shares of IBM and AAPL, 
downloaded from Quandl.
}
\examples{
data(stock_returns)
str(stock_returns)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{data}
