% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wemo_PORT}
\alias{wemo_PORT}
\title{WeMo Switch Port}
\usage{
wemo_PORT(ip, timeout = 0.1)
}
\arguments{
\item{ip}{A characted string or vector of character strings representing the
IP address(es) of WeMo Switch smart plug(s).}

\item{timeout}{Number of seconds to wait for a response until giving up. Can
not be less than 1 ms (default: 0.1).}
}
\value{
A \code{\link[tibble]{tibble}} with two columns:
  \describe{
    \item{ip}{The IP address of the WeMo Switch smart plug.}
    \item{port}{The port at which the WeMo Switch smart plug can be accessed.
                NA will be returned is no WeMo Switch is detected at this IP.}
  }
}
\description{
Automatically detects the port used by WeMo Switch smart plugs.
}
\examples{
\dontrun{
wemo_PORT("192.0.1.1")
}

}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
