# WARNING - Generated by {fusen} from dev/dereplicate-spectra.Rmd: do not edit by hand

directory_biotyper_spectra <- system.file("toy-species-spectra", package = "maldipickr")
spectra_list_test <- import_biotyper_spectra(directory_biotyper_spectra)[1:2]
test_that("process_spectra works", {
  expect_equal(
    process_spectra(spectra_list_test)$metadata,
    structure(
      list(
        name = c("species1_G2", "species2_E11"),
        SNR = c(5.08959045014141, 5.54373537030499),
        peaks = c(21, 22)
      ),
      row.names = c(NA, -2L),
      class = c("tbl_df", "tbl", "data.frame")
    )
  )
})
test_that("process_spectra with automatic names fails on empty spectra with maldipickr functions", {
  expect_error(
    process_spectra(c(MALDIquant::createMassSpectrum(0, 0))),
    "Empty spectra detected!"
  )
})
test_that("process_spectra with manual names warns on empty spectra with MALDIquant functions", {
  expect_warning(
    process_spectra(
      c(MALDIquant::createMassSpectrum(0, 0)),
      spectra_names = tibble::tibble(sanitized_name = "Dummy_name")
    ),
    "MassSpectrum object is empty"
  )
})
test_that("process_spectra with manual names fails if wrong column", {
  expect_error(
    process_spectra(
      spectra_list_test,
      spectra_names = tibble::tibble(
        sanitized_wrong_column = c("spectra1","spectra2")
        )
    ),
    "Missing 'sanitized_name' column"
  )
})
