% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colombian_sea.R
\docType{data}
\name{Colombian_sea}
\alias{Colombian_sea}
\title{Colombian_sea Dataset}
\format{
Simple feature collection with 6 features and 5 fields:
\describe{
\item{MRGID}{id from original GDAM}
\item{GEONAME}{id from original GDAM}
\item{SOVEREIGN1}{Colombia.}
\item{NAME_1}{Departamentos.}
\item{DEPARTAMEN}{class name GDAM.}
\item{geometry}{order name of GDAM.}
}
}
\usage{
Colombian_sea
}
\description{
The colombian_sea dataset is a simple feature collection with 6 features and 5 fields. This version
was obtained from marine regions page: "https://www.marineregions.org/stats_downloads.php"
}
\details{
This dataset is designed to provide users of mammalcol package with a companion map to
plot the mammal distribution per departamento.
}
\examples{

# Load the mammalcol package
library (mammalcol)
library (sf)

# Access the Colombian_sea dataset
# data ("colombian_sea")

# Display the first few rows
head (Colombian_sea)

plot (Colombian_sea["NAME_1"])

}
\references{
The dataset is based on the "List of the Mammals of Colombia" by Ramírez-Chaves 2021.
}
\seealso{
For more information about the "mammalcol" package and the data sources, visit
the package's GitHub repository: \url{https://github.com/dlizcano/mammalcol}
}
\author{
Data compilation: Ramírez-Chaves 2021, Function implementation: Cristian A. Cruz-R.
}
\keyword{internal}
