% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mamm_coords_validator.r
\name{mamm_coords_validator}
\alias{mamm_coords_validator}
\title{Validate mammal species distribution data based on geographic coordinates.}
\usage{
mamm_coords_validator(
  df,
  sp_names,
  taxon = NULL,
  colmap_d = NULL,
  lon = NULL,
  lat = NULL,
  adm_names = NULL,
  oceanmap = NULL,
  oce_adm_names = NULL
)
}
\arguments{
\item{df}{A data frame containing species distribution data with columns 'species',
'decimalLongitude', and 'decimalLatitude'.}

\item{sp_names}{Name of the column containing species names (Genus + Specific Epithet).}

\item{taxon}{A data frame with distribution information, including 'scientificName' and 'distribution'.
The scientificName must be in binomial form, and the distribution should contain names separated by |.
By default, the function uses the checklist available at https://www.gbif.org/dataset/e8b9ed9b-f715-4eac-ae24-772fbf40d7ae.}

\item{colmap_d}{A spatial object in vector format representing the geographic area to validate against.
By default, the function uses the Colombia Administrative Boundaries available in the geodata package.}

\item{lon}{Name of the column containing longitude values in df. Default is 'decimalLongitude'.}

\item{lat}{Name of the column containing latitude values in df. Default is 'decimalLatitude'.}

\item{adm_names}{Name of the column in colmap representing administrative boundaries. Default is 'NAME_1'.}

\item{oceanmap}{A spatial object representing the ocean area to validate against.}

\item{oce_adm_names}{Name of the column in oceanmap representing administrative boundaries for ocean areas. Default is 'ocean'.}
}
\value{
A data frame with validated species records and validation results.
}
\description{
This function validates species distribution data provided in a data frame
against the known mammal species lists and a departamentos map. It outputs
a data frame with validation results and additional information.
}
\details{
This function validates species distribution data by checking species names against a
known list and verifying geographic coordinates against political maps ('colmap_d' and 'oceanmap').
'colmap_d' is downloaded internally using the geodata package.
It assigns a validation result ('validation_result') where 1 means coincidence and 0 means
no match. Additional details are provided in the returned data frame.
}
\examples{
\donttest{
validated_data <- mamm_coords_validator (df = test_data_coordiantes, sp_names = "species")
}

}
