% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/SOManifold.R,
%   R/SPDManifolds.R, R/SphereManifold.R, R/TorusManifold.R
\name{basisTan.Euclidean}
\alias{basisTan.Euclidean}
\alias{basisTan}
\alias{basisTan.SO}
\alias{basisTan.SPD}
\alias{basisTan.Sphere}
\alias{basisTan.FlatTorus}
\title{Obtain an orthonormal basis on the tangent space}
\usage{
\method{basisTan}{Euclidean}(mfd, p)

basisTan(mfd, p)

\method{basisTan}{SO}(mfd, p)

\method{basisTan}{SPD}(mfd, p)

\method{basisTan}{Sphere}(mfd, p)

\method{basisTan}{FlatTorus}(mfd, p)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p}{A vector for a base point on the manifold}
}
\value{
An orthonormal basis matrix D, whose columns contain the basis vectors, so that `D^T v` give the coordinates `v0` for a tangent vector `v`, and `D%*%v0 = v`.
}
\description{
Parametrize the tangent space at location p, so that the parameterized version contains an open neighborhood around the origin. (The dimension of v is potentially reduced).
}
\section{Methods (by class)}{
\itemize{
\item \code{basisTan(Euclidean)}: An identity matrix

\item \code{basisTan(SO)}: An identity matrix

\item \code{basisTan(SPD)}: The basis is obtained from enumerating the (non-strict) lower-triangle of a square matrix. If i != j, the (i, j)th entry is mapped into a matrix with 1/sqrt(2) in the (i,j) and (j,i) entries and 0 in other entries; if (i == j), it is mapped to a matrix with 1 in the ith diagonal element and 0 otherwise. The mapped matrix is then vectorized to obtain the basis vector.

\item \code{basisTan(Sphere)}: The basis at the north pole is [0, ..., 1, ..., 0] where the 1 is at the j = 2, ..., dAmbth location. The basis at a point p is obtained through rotating the basis from the north pole to p along the shortest geodesic.

\item \code{basisTan(FlatTorus)}: An identity matrix

}}
