% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{distance.Euclidean}
\alias{distance.Euclidean}
\alias{distance}
\alias{distance.L2}
\alias{distance.HS}
\alias{distance.Dens}
\alias{distance.SO}
\alias{distance.LogEu}
\alias{distance.AffInv}
\alias{distance.Sphere}
\title{Geodesic distance}
\usage{
\method{distance}{Euclidean}(mfd, X, Y, ...)

distance(mfd, X, Y, ...)

\method{distance}{L2}(mfd, X, Y, ...)

\method{distance}{HS}(mfd, X, Y, ...)

\method{distance}{Dens}(mfd, X, Y, ...)

\method{distance}{SO}(mfd, X, Y, ...)

\method{distance}{LogEu}(mfd, X, Y, assumeLogRep = FALSE, ...)

\method{distance}{AffInv}(mfd, X, Y, ...)

\method{distance}{Sphere}(mfd, X, Y, ...)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{X, Y}{Matrices with n columns. The distance between each pair of columns is calculated. If either X or Y is a vector then it is recycled.}

\item{...}{Passed into specific methods}

\item{assumeLogRep}{Whether to assume the input are already the representations under the logarithm map}
}
\value{
A vector with n entries containing the distances between pairs of points
}
\description{
Geodesic distance
}
\section{Methods (by class)}{
\itemize{
\item \code{distance(Euclidean)}: Method

\item \code{distance(L2)}: Method

\item \code{distance(HS)}: Method

\item \code{distance(Dens)}: Method

\item \code{distance(SO)}: Method

\item \code{distance(LogEu)}: Method

\item \code{distance(AffInv)}: Method

\item \code{distance(Sphere)}: Method

}}
