% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{addMapboxTiles}
\alias{addMapboxTiles}
\title{Use a Mapbox style in a Leaflet map}
\usage{
addMapboxTiles(
  map,
  style_id,
  username,
  style_url = NULL,
  scaling_factor = c("1x", "0.5x", "2x"),
  access_token = NULL,
  layerId = NULL,
  group = NULL,
  options = leaflet::tileOptions(),
  data = leaflet::getMapData(map),
  attribution = TRUE
)
}
\arguments{
\item{map}{A map widget object created by \code{\link[leaflet:leaflet]{leaflet::leaflet()}}}

\item{style_id}{The style ID of a Mapbox style}

\item{username}{A Mapbox username}

\item{style_url}{A Mapbox style URL}

\item{scaling_factor}{The scaling factor to use when rendering the tiles. A
scaling factor of \code{"1x"} (the default) returns 512px by 512px tiles. A
factor of \code{"1x"} returns 256x256 tiles, and a factor of \code{"2x"} returns
1024x1024 tiles.}

\item{access_token}{Your Mapbox access token; which can be set with
\code{\link[=mb_access_token]{mb_access_token()}}.}

\item{layerId}{the layer ID}

\item{group}{The name of the group the Mapbox tile layer should belong to
(for use in Shiny and to modify layers control in a Leaflet workflow)}

\item{options}{A list of extra options (optional)}

\item{data}{The data object used to derive argument values; can be provided
to the initial call to \code{\link[leaflet:leaflet]{leaflet::leaflet()}}}

\item{attribution}{If \code{TRUE}, pass a standard attribution to
\code{\link[leaflet:map-layers]{leaflet::addTiles()}}. If \code{FALSE}, attribution is \code{NULL}. attribution can
also be a character string including HTML.}
}
\value{
A pointer to the Mapbox Static Tiles API which will be translated
appropriately by the leaflet R package.
}
\description{
See the \href{https://docs.mapbox.com/api/maps/static-tiles/}{Mapbox Static Tiles API documentation} for more
information.
}
\examples{
\dontrun{

library(leaflet)
library(mapboxapi)

leaflet() \%>\%
  addMapboxTiles(
    style_id = "light-v9",
    username = "mapbox"
  ) \%>\%
  setView(
    lng = -74.0051,
    lat = 40.7251,
    zoom = 13
  )
}

}
