% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maraca.R
\name{plot.hce}
\alias{plot.hce}
\title{Generic function to plot the hce object using plot().}
\usage{
\method{plot}{hce}(
  x,
  step_outcomes = NULL,
  last_outcome = "C",
  arm_levels = c(active = "A", control = "P"),
  continuous_grid_spacing_x = 10,
  trans = c("identity", "log", "log10", "sqrt", "reverse")[1],
  density_plot_type = c("default", "violin", "box", "scatter")[1],
  vline_type = NULL,
  fixed_followup_days = NULL,
  compute_win_odds = FALSE,
  step_types = "tte",
  last_type = "continuous",
  theme = "maraca",
  lowerBetter = FALSE,
  tte_outcomes = lifecycle::deprecated(),
  continuous_outcome = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{x}{an object of S3 class 'hce'.}

\item{step_outcomes}{A vector of strings containing the outcome labels
for all outcomes displayed as part of the step function
on the left side of the plot.
The order is kept for the plot.
By default (when set to NULL) this is automatically
updated by taking the non-continuous outcomes from
the GROUP variable in alphabetical order.}

\item{last_outcome}{A single string containing the last outcome label
displayed on the right side of the plot.
Default value "C".}

\item{arm_levels}{A named vector of exactly two strings, mapping the
values used for the active and control arms to the values
used in the data. The names must be "active" and "control"
in this order. Note that this parameter only need to
be specified if you have labels different from
"active" and "control".}

\item{continuous_grid_spacing_x}{The spacing of the x grid to use for the
continuous section of the plot.}

\item{trans}{the transformation to apply to the x-axis scale for the last
outcome. Possible values are "identity", "log" (only for continuous
endpoint), "log10" (only for continuous endpoint), "sqrt" (only for
continuous endpoint) and "reverse". The default value is "identity".}

\item{density_plot_type}{The type of plot to use to represent the density.
Accepts "default", "violin", "box" and "scatter".}

\item{vline_type}{what the vertical dashed line should represent. Accepts
"median" (only for continuous last endpoint), "mean", "none" and
NULL (default). By default (vline_type = NULL), vline_type will be
set to "median" for a continuous last endpoint and to "mean" for
a binary last endpoint.}

\item{fixed_followup_days}{Not needed if HCE object contains information
on fixed follow-up days in the study
(column PADY or TTEfixed,
depending on hce version).
Otherwise, this argument must be specified
to give the fixed follow-up days in the study.
Can be a single integer value
for all tte-outcomes or a vector with one
integer value per tte-outcome.
Note: If argument is specified and HCE object
also contains PADY or TTEfixed column, then
fixed_followup_days argument is used.}

\item{compute_win_odds}{If TRUE compute the win odds, otherwise (default)
don't compute them.}

\item{step_types}{The type of each outcome in the step_outcomes vector.
Can be a single string (if all outcomes of same type) or
a vector of same length as step_outcomes. Possible values
in the vector are "tte" (default) or "binary".}

\item{last_type}{A single string giving the type of the last outcome.
Possible values are "continuous" (default), "binary" or
"multinomial".}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "maraca_old", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Themes and Styling".
[companion vignette for package users](themes.html)}

\item{lowerBetter}{Flag for the final outcome variable, indicating if
lower values are considered better/advantageous.
This flag is need to make sure the win odds are
calculated correctly.
Default value is FALSE, meaning higher values
are considered advantageous.}

\item{tte_outcomes}{Deprecated and substituted by the more general
'step_outcomes'. A vector of strings containing the
time-to-event outcome labels. The order is kept for the
plot.}

\item{continuous_outcome}{Deprecated and substituted by the more general
'last_outcome'. A single string containing the
continuous outcome label.}

\item{\dots}{not used}
}
\value{
Returns ggplot2 plot of the hce object.
}
\description{
Generic function to plot the hce object using plot().
}
\examples{
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
hce_dat <- hce::simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
             CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3,
             seed = 31337)
plot(hce_dat)
plot(hce_dat, fixed_followup_days = 3 * 365)

}
