/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.iterators.EmptyIterator;
import choco.kernel.common.util.iterators.TIHIterator;
import choco.kernel.common.util.objects.DeterministicIndicedList;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.IOptions;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.ComponentConstraintWithSubConstraints;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealExpressionVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.set.SetExpressionVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class CPModel
implements Model {
    private static final String NO_OPTIONS = "";
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected final DeterministicIndicedList<Constraint> constraints;
    protected final DeterministicIndicedList<IntegerVariable> intVars;
    protected int nbBoolVar;
    protected final DeterministicIndicedList<SetVariable> setVars;
    protected final DeterministicIndicedList<RealVariable> floatVars;
    protected final DeterministicIndicedList<Variable> constantVars;
    protected final DeterministicIndicedList<IntegerExpressionVariable> expVars;
    protected final DeterministicIndicedList<MultipleVariables> storedMultipleVariables;
    private final THashMap<ConstraintType, TIntHashSet> constraintsByType;
    protected Boolean defDecExp;
    protected ComponentConstraintWithSubConstraints clausesStore = null;
    protected TIHIterator<Constraint> _iterator;
    public static final Properties properties = new Properties();
    private final Set<String> reuseOptions = new HashSet<String>(3);
    private final TLongHashSet conSet = new TLongHashSet();
    private final TLongHashSet varSet = new TLongHashSet();
    private final TLongObjectHashMap<Constraint> conQueue = new TLongObjectHashMap();
    private final TLongObjectHashMap<Variable> varQueue = new TLongObjectHashMap();

    public CPModel() {
        this(32, 32, 32, 32, 32, 32, 32);
    }

    public CPModel(int nbCstrs, int nbIntVars, int nbSetVars, int nbRealVars, int nbCsts, int nbExpVars, int nbMultVars) {
        this.intVars = new DeterministicIndicedList(IntegerVariable.class, nbIntVars);
        this.setVars = new DeterministicIndicedList(SetVariable.class, nbSetVars);
        this.floatVars = new DeterministicIndicedList(RealVariable.class, nbRealVars);
        this.constantVars = new DeterministicIndicedList(Variable.class, nbCsts);
        this.expVars = new DeterministicIndicedList(IntegerExpressionVariable.class, nbExpVars);
        this.storedMultipleVariables = new DeterministicIndicedList(MultipleVariables.class, nbMultVars);
        this.constraints = new DeterministicIndicedList(Constraint.class, nbCstrs);
        this.constraintsByType = new THashMap();
    }

    public void removeConstraints() {
        DisposableIterator<Constraint> itc = this.constraints.iterator();
        while (itc.hasNext()) {
            this.remove(itc.next());
        }
        itc.dispose();
        this.remove(this.clausesStore);
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer("Pb[" + this.getNbTotVars() + " vars, " + this.getNbStoredMultipleVars() + " multiple vars, " + this.getNbConstraints() + " cons]\n");
        buf.append(this.varsToString());
        buf.append(this.constraintsToString());
        return new String(buf);
    }

    @Override
    public String varsToString() {
        StringBuffer buf = new StringBuffer("==== VARIABLES ====\n");
        buf.append(StringUtils.prettyOnePerLine(this.intVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.floatVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.setVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.constantVars.iterator()));
        buf.append("==== MULTIPLE VARIABLES ====\n");
        buf.append(StringUtils.prettyOnePerLine(this.storedMultipleVariables.iterator()));
        return new String(buf);
    }

    @Override
    public String constraintsToString() {
        StringBuffer buf = new StringBuffer("==== CONSTRAINTS ====\n");
        buf.append(StringUtils.prettyOnePerLine(this.constraints.iterator()));
        return new String(buf);
    }

    @Override
    public String solutionToString() {
        StringBuffer buf = new StringBuffer(24);
        buf.append(StringUtils.prettyOnePerLine(this.intVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.floatVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.setVars.iterator()));
        buf.append(StringUtils.prettyOnePerLine(this.constantVars.iterator()));
        return new String(buf);
    }

    @Override
    @Deprecated
    public int getIntVarIndex(IntDomainVar c) {
        throw new ModelException("CPModel: ?");
    }

    @Override
    @Deprecated
    public int getIntVarIndex(IntVar c) {
        throw new ModelException("CPModel: ?");
    }

    @Override
    public Boolean getDefaultExpressionDecomposition() {
        return this.defDecExp;
    }

    @Override
    public void setDefaultExpressionDecomposition(Boolean defDecExp) {
        this.defDecExp = defDecExp;
    }

    @Override
    public final IntegerVariable getIntVar(int i) {
        return this.intVars.get(i);
    }

    @Override
    public final int getNbIntVars() {
        return this.intVars.size();
    }

    @Override
    public final RealVariable getRealVar(int i) {
        return this.floatVars.get(i);
    }

    @Override
    public final int getNbRealVars() {
        return this.floatVars.size();
    }

    @Override
    public final SetVariable getSetVar(int i) {
        return this.setVars.get(i);
    }

    @Override
    public final int getNbSetVars() {
        return this.setVars.size();
    }

    @Override
    public int getNbTotVars() {
        return this.getNbIntVars() + this.getNbRealVars() + this.getNbSetVars();
    }

    @Override
    public IntegerConstantVariable getConstantVar(int i) {
        return (IntegerConstantVariable)this.constantVars.get(i);
    }

    @Override
    public int getNbConstantVars() {
        return this.constantVars.size();
    }

    @Override
    public int getNbStoredMultipleVars() {
        return this.storedMultipleVariables.size();
    }

    @Override
    public MultipleVariables getStoredMultipleVar(int i) {
        return this.storedMultipleVariables.get(i);
    }

    @Override
    public final int getNbConstraints() {
        return this.constraints.size();
    }

    @Override
    public final Constraint getConstraint(int i) {
        return this.constraints.get(i);
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getIntConstraintIterator() {
        return this.getConstraintIterator();
    }

    @Override
    public Iterator<Constraint> getConstraintIterator() {
        return this.constraints.iterator();
    }

    public DisposableIterator<Constraint> getConstraintByType(ConstraintType t) {
        TIntHashSet hs = this.constraintsByType.get((Object)t);
        if (hs != null) {
            if (this._iterator == null || !this._iterator.reusable()) {
                this._iterator = new TIHIterator();
            }
            this._iterator.init(hs, this.constraints);
            return this._iterator;
        }
        return EmptyIterator.get();
    }

    @Override
    public int getNbConstraintByType(ConstraintType t) {
        TIntHashSet hs = this.constraintsByType.get((Object)t);
        if (hs != null) {
            return hs.size();
        }
        return 0;
    }

    @Override
    public void addOptions(String options, IOptions ... element) {
        DisposableIterator<String> iter = StringUtils.getOptionIterator(options);
        while (iter.hasNext()) {
            for (IOptions anElement : element) {
                anElement.addOption((String)iter.next());
            }
        }
        iter.dispose();
    }

    @Override
    public void addVariable(Variable v) {
        this.addVariables(NO_OPTIONS, v);
    }

    @Override
    public void addVariable(String options, Variable v) {
        this.addVariables(options, v);
    }

    @Override
    @Deprecated
    public void addVariable(Variable ... v) {
        this.addVariables(NO_OPTIONS, v);
    }

    @Override
    @Deprecated
    public void addVariable(String options, Variable ... v) {
        this.addVariables(options, v);
    }

    @Override
    public void addVariables(Variable ... tabv) {
        this.addVariables(NO_OPTIONS, tabv);
    }

    @Override
    public void addVariables(String options, Variable ... tabv) {
        this.addOptions(options, tabv);
        block12: for (Variable v : tabv) {
            v.findManager(properties);
            switch (v.getVariableType()) {
                case INTEGER: {
                    if (((IntegerVariable)v).isBoolean()) {
                        ++this.nbBoolVar;
                    }
                    this.intVars.add((IntegerVariable)v);
                    continue block12;
                }
                case SET: {
                    this.setVars.add((SetVariable)v);
                    this.addVariable(options, (Variable)((SetVariable)v).getCard());
                    continue block12;
                }
                case REAL: {
                    this.floatVars.add((RealVariable)v);
                    continue block12;
                }
                case CONSTANT_INTEGER: {
                    if (((IntegerConstantVariable)v).isBoolean()) {
                        ++this.nbBoolVar;
                    }
                    this.constantVars.add(v);
                    continue block12;
                }
                case CONSTANT_DOUBLE: {
                    this.constantVars.add(v);
                    continue block12;
                }
                case CONSTANT_SET: {
                    this.constantVars.add(v);
                    this.addVariable(options, (Variable)((SetVariable)v).getCard());
                    continue block12;
                }
                case INTEGER_EXPRESSION: {
                    IntegerExpressionVariable iev = (IntegerExpressionVariable)v;
                    DisposableIterator<Variable> it = iev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable((Variable)it.next());
                    }
                    continue block12;
                }
                case SET_EXPRESSION: {
                    SetExpressionVariable sev = (SetExpressionVariable)v;
                    DisposableIterator<Variable> it = sev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable((Variable)it.next());
                    }
                    continue block12;
                }
                case REAL_EXPRESSION: {
                    RealExpressionVariable rev = (RealExpressionVariable)v;
                    DisposableIterator<Variable> it = rev.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable((Variable)it.next());
                    }
                    continue block12;
                }
                case MULTIPLE_VARIABLES: {
                    MultipleVariables mv = (MultipleVariables)v;
                    DisposableIterator<Variable> it = mv.getVariableIterator();
                    while (it.hasNext()) {
                        this.addVariable((Variable)it.next());
                    }
                    if (!mv.isStored() || this.storedMultipleVariables.contains(mv)) continue block12;
                    this.storedMultipleVariables.add(mv);
                    continue block12;
                }
                default: {
                    throw new ModelException("unknown variable type :" + (Object)((Object)v.getVariableType()));
                }
            }
        }
    }

    public int getNbBoolVar() {
        return this.nbBoolVar;
    }

    @Deprecated
    protected <E extends Variable> void removeVariable(E v, DeterministicIndicedList<E> vars) {
        vars.remove(v);
        Iterator<Constraint> it = v.getConstraintIterator(this);
        while (it.hasNext()) {
            Constraint c = it.next();
            it.remove();
            this.removeConstraint(c);
        }
    }

    protected <E extends Variable> void remVariable(E v) {
        switch (v.getVariableType()) {
            case INTEGER: {
                IntegerVariable vi = (IntegerVariable)v;
                this.intVars.remove(vi);
                if (!vi.isBoolean()) break;
                --this.nbBoolVar;
                break;
            }
            case SET: {
                SetVariable sv = (SetVariable)v;
                this.intVars.remove(sv.getCard());
                this.setVars.remove(sv);
                break;
            }
            case REAL: {
                RealVariable rv = (RealVariable)v;
                this.floatVars.remove(rv);
                break;
            }
            case CONSTANT_INTEGER: 
            case CONSTANT_DOUBLE: 
            case CONSTANT_SET: {
                return;
            }
            case INTEGER_EXPRESSION: {
                IntegerExpressionVariable iev = (IntegerExpressionVariable)v;
                DisposableIterator<Variable> it = iev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable((Variable)it.next());
                }
                break;
            }
            case SET_EXPRESSION: {
                SetExpressionVariable sev = (SetExpressionVariable)v;
                DisposableIterator<Variable> it = sev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable((Variable)it.next());
                }
                break;
            }
            case REAL_EXPRESSION: {
                RealExpressionVariable rev = (RealExpressionVariable)v;
                DisposableIterator<Variable> it = rev.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable((Variable)it.next());
                }
                break;
            }
            case MULTIPLE_VARIABLES: {
                MultipleVariables mv = (MultipleVariables)v;
                DisposableIterator<Variable> it = mv.getVariableIterator();
                while (it.hasNext()) {
                    this.removeVariable((Variable)it.next());
                }
                this.storedMultipleVariables.remove(mv);
                break;
            }
            default: {
                throw new ModelException("unknown variable type :" + (Object)((Object)v.getVariableType()));
            }
        }
    }

    public void remove(Object ob) {
        Variable v;
        Constraint c;
        if (ob instanceof Constraint) {
            c = (Constraint)ob;
            this.conQueue.put(c.getIndex(), c);
            Constraint clast = this.constraints.getLast();
            int id = this.constraints.remove(c);
            TIntHashSet hs = this.constraintsByType.get((Object)c.getConstraintType());
            hs.remove(id);
            if (id != -1 && clast != null && c.getIndex() != clast.getIndex()) {
                hs = this.constraintsByType.get((Object)clast.getConstraintType());
                hs.remove(this.constraints.size());
                hs.add(id);
            }
        } else if (ob instanceof Variable) {
            v = (Variable)ob;
            this.varQueue.put(v.getIndex(), v);
            this.remVariable(v);
        }
        while (!this.varQueue.isEmpty() || !this.conQueue.isEmpty()) {
            for (long key : this.conQueue.keys()) {
                c = this.conQueue.remove(key);
                DisposableIterator<Variable> itv = c.getVariableIterator();
                while (itv.hasNext()) {
                    v = (Variable)itv.next();
                    v._removeConstraint(c);
                    if (v.getNbConstraint(this) != 0 || this.varSet.contains(v.getIndex())) continue;
                    this.remVariable(v);
                    this.varQueue.put(v.getIndex(), v);
                }
                itv.dispose();
                this.conSet.add(c.getIndex());
            }
            for (long key : this.varQueue.keys()) {
                v = this.varQueue.remove(key);
                Iterator<Constraint> itc = v.getConstraintIterator(this);
                while (itc.hasNext()) {
                    c = itc.next();
                    if (this.conSet.contains(c.getIndex())) continue;
                    this.conQueue.put(c.getIndex(), c);
                    Constraint clast = this.constraints.getLast();
                    int id = this.constraints.remove(c);
                    TIntHashSet hs = this.constraintsByType.get((Object)c.getConstraintType());
                    hs.remove(id);
                    if (id == -1 || clast == null || c.getIndex() == clast.getIndex()) continue;
                    hs = this.constraintsByType.get((Object)clast.getConstraintType());
                    hs.remove(this.constraints.size());
                    hs.add(id);
                }
                this.varSet.add(v.getIndex());
            }
        }
    }

    @Override
    public void removeConstraint(Constraint c) {
        this.remove(c);
    }

    @Override
    @Deprecated
    public void removeVariable(Variable ... v) {
        for (Variable aV : v) {
            this.remove(aV);
        }
    }

    @Override
    public void removeVariable(Variable v) {
        this.remove(v);
    }

    @Override
    public void removeVariables(Variable ... v) {
        for (Variable aV : v) {
            this.remove(aV);
        }
    }

    private void updateConstraintByType(ConstraintType t, Constraint c) {
        int id;
        TIntHashSet hs = this.constraintsByType.get((Object)t);
        if (hs == null) {
            hs = new TIntHashSet();
        }
        if (!hs.contains(id = this.constraints.get(c))) {
            hs.add(id);
        }
        this.constraintsByType.put(t, hs);
    }

    @Override
    @Deprecated
    public void addConstraint(Constraint ... c) {
        this.addConstraints(NO_OPTIONS, c);
    }

    @Override
    @Deprecated
    public void addConstraint(String options, Constraint ... c) {
        this.addConstraints(options, c);
    }

    @Override
    public void addConstraint(Constraint c) {
        this.addConstraints(NO_OPTIONS, c);
    }

    @Override
    public void addConstraints(Constraint ... c) {
        this.addConstraints(NO_OPTIONS, c);
    }

    @Override
    public void addConstraint(String options, Constraint c) {
        this.addConstraints(options, c);
    }

    @Override
    public void addConstraints(String options, Constraint ... tabc) {
        this.addOptions(options, tabc);
        for (Constraint c : tabc) {
            c.addOptions(this.reuseOptions);
            c.findManager(properties);
            switch (c.getConstraintType()) {
                case CLAUSES: {
                    this.storeClauses((ComponentConstraint)c);
                    break;
                }
                default: {
                    if (this.constraints.contains(c)) break;
                    this.constraints.add(c);
                }
            }
            this.updateConstraintByType(c.getConstraintType(), c);
            DisposableIterator<Variable> it = c.getVariableIterator();
            while (it.hasNext()) {
                Variable v = (Variable)it.next();
                if (v == null) {
                    LOGGER.severe("Adding null variable in the model !");
                }
                this.addVariable(v);
                if (v.getVariableType() == VariableType.CONSTANT_INTEGER || v.getVariableType() == VariableType.CONSTANT_SET) continue;
                v._addConstraint(c);
            }
            it.dispose();
        }
    }

    private void storeClauses(ComponentConstraint clause) {
        if (this.clausesStore == null) {
            this.clausesStore = new ComponentConstraintWithSubConstraints(ConstraintType.CLAUSES, clause.getVariables(), null, clause);
            this.clausesStore.addOptions(clause.getOptions());
            this.clausesStore.findManager(properties);
            this.constraints.add(this.clausesStore);
        } else {
            this.clausesStore.addElements(clause.getVariables(), clause);
        }
    }

    @Override
    public Iterator<IntegerVariable> getIntVarIterator() {
        return this.intVars.iterator();
    }

    @Override
    public Iterator<RealVariable> getRealVarIterator() {
        return this.floatVars.iterator();
    }

    @Override
    public Iterator<SetVariable> getSetVarIterator() {
        return this.setVars.iterator();
    }

    @Override
    public Iterator<Variable> getConstVarIterator() {
        return this.constantVars.iterator();
    }

    public Iterator<IntegerExpressionVariable> getExprVarIterator() {
        return this.expVars.iterator();
    }

    @Override
    public Iterator<MultipleVariables> getMultipleVarIterator() {
        return this.storedMultipleVariables.iterator();
    }

    @Override
    public boolean contains(Constraint c) {
        return this.constraints.contains(c);
    }

    public static void writeInFile(CPModel model, File file) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(file);
        out = new ObjectOutputStream(fos);
        out.writeObject(model);
        out.close();
    }

    public static File writeInFile(CPModel model) throws IOException {
        File file = File.createTempFile("CPMODEL_", ".ser");
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(file);
        out = new ObjectOutputStream(fos);
        out.writeObject(model);
        out.close();
        return file;
    }

    public static CPModel readFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        fis = new FileInputStream(file);
        in = new ObjectInputStream(fis);
        CPModel model = (CPModel)in.readObject();
        in.close();
        return model;
    }

    static {
        try {
            InputStream is = CPModel.class.getResourceAsStream("/application.properties");
            properties.load(is);
        }
        catch (IOException e) {
            LOGGER.severe("Could not open application.properties");
        }
    }

    static class TroveIterator
    implements Iterator<Constraint> {
        private final TLongObjectIterator<Constraint> iterator;

        TroveIterator(TLongObjectIterator<Constraint> tit) {
            this.iterator = tit;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Constraint next() {
            this.iterator.advance();
            return this.iterator.value();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

