% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setUpPopulations.R
\name{simulateScene}
\alias{simulateScene}
\title{Simulate a Mating Scene}
\usage{
simulateScene(
  size = 30,
  meanSD = "2012-07-12",
  sdSD = 6,
  meanDur = 11,
  sdDur = 3,
  skSD = 0,
  xRange = c(0, 100),
  yRange = c(0, 100),
  distro = "unif",
  sAlleles = 10
)
}
\arguments{
\item{size}{integer number of plants}

\item{meanSD}{date mean start date}

\item{sdSD}{date standard deviation of start date}

\item{meanDur}{numeric duration in days}

\item{sdDur}{standard deviation of duration in days}

\item{skSD}{skew of the start date of the population}

\item{xRange}{range of spatial extent of individuals along x-axis}

\item{yRange}{range of spatial extent of individuals along y-axis}

\item{distro}{unimplemented}

\item{sAlleles}{integer count of S-Alleles that could be in the population}
}
\value{
matingScene data frame -- see \code{\link{makeScene}}
}
\description{
simulateScene generates a matingScene object -- a simulated population
in a standard format with individuals randomly assigned a mating schedule,
a location, and S-alleles
}
\examples{
simulateScene()
}
\seealso{
\code{\link{makeScene}}
}
\author{
Stuart Wagenius
}
