% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{binding}
\alias{binding}
\alias{col_bind}
\alias{row_bind}
\title{Bind vector, single values and matrices}
\usage{
col_bind(...)

row_bind(...)
}
\arguments{
\item{...}{single values, vectors, matrices or data.frames}
}
\value{
a matrix being a product of matrix/vector/values binding
}
\description{
This functions works very similar to well-known base
`cbind` or `rbind`  function. However, there is one big difference
between these functions. If you pass a vector, each value
will be get individually.
}
\examples{
# `col_bind` vs `cbind`
cbind(1,2,3,4,5)
col_bind(1,2,3,4,5)
cbind(1:5)
col_bind(1:5)
cbind(matrix(3, 3, 3), 0.33, 4:7)
col_bind(matrix(3, 3, 3), 0.33, 4:7)
# `row_bind` vs `rbind`
rbind(1,2,3,4,5)
row_bind(1,2,3,4,5)
rbind(1:5)
row_bind(1:5)
rbind(matrix(3, 3, 3), 0.33, 4:7)
row_bind(matrix(3, 3, 3), 0.33, 4:7)
}
