% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHkindone.R
\name{rmatrixCHkind1}
\alias{rmatrixCHkind1}
\title{Sampler of the matrix variate confluent hypergometric kind one distribution}
\usage{
rmatrixCHkind1(n, nu, alpha, beta, theta = 1, Sigma = NULL, p,
  checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{shape parameter, a positive number; if \code{nu < (p-1)/2},
where \code{p} is the dimension (the order of \code{Sigma}), then \code{nu}
must be a half integer}

\item{alpha, beta}{shape parameters with the following constraints:
\code{b = a} or \code{b > a > nu + (p-1)/2}}

\item{theta}{scale parameter, a positive number}

\item{Sigma}{scale matrix, a symmetric positive definite matrix, or
\code{NULL} for the identity matrix of order \code{p}}

\item{p}{if \code{Sigma} is \code{NULL}, this sets \code{Sigma} to the
identity matrix of order \code{p}; ignored if \code{Sigma} is not \code{NULL}}

\item{checkSymmetry}{logical, whether to check that \code{Sigma} is a
symmetric positive definite matrix}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension.
}
\description{
Samples the matrix variate confluent hypergometric kind one distribution.
}
\note{
For \code{alpha = beta}, this is the matrix variate Gamma distribution
with parameters \code{nu}, \code{theta}, \code{Sigma}.
}
\examples{
nu <- 5; alpha <- 10; beta <- 12; theta <- 2; p <- 3; Sigma <- toeplitz(3:1)
CHsims <- rmatrixCHkind1(10000, nu, alpha, beta, theta, Sigma)
# simulations of the trace
sims <- apply(CHsims, 3, function(X) sum(diag(X)))
mean(sims)
theta * nu * (nu-beta+(p+1)/2) / (nu-alpha+(p+1)/2) * sum(diag(Sigma))
}
\references{
Gupta & al.
Properties of Matrix Variate Confluent Hypergeometric Function Distribution.
\emph{Journal of Probability and Statistics}
vol. 2016, Article ID 2374907, 12 pages, 2016.
}
