% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rwishart}
\alias{rwishart}
\title{Wishart sampler}
\usage{
rwishart(n, nu, Sigma, Theta = NULL, epsilon = 0,
  checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{degrees of freedom, a positive number;
if \code{nu < p-1} where \code{p} is the dimension (the order of \code{Sigma}),
must be an integer;
in the noncentral case (i.e. when \code{Theta} is not the null matrix), \code{nu}
must satisfy \code{nu >= p-1}}

\item{Sigma}{scale matrix, a positive semidefinite real matrix}

\item{Theta}{noncentrality parameter, a positive semidefinite real matrix of
same order as \code{Sigma}; setting it to \code{NULL} (default) is
equivalent to setting it to the zero matrix}

\item{epsilon}{a number involved in the algorithm only if it positive; its role
is to guarantee the invertibility of the sampled matrices; see Details}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{Sigma}
and \code{Theta}}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples a Wishart distribution.
}
\details{
The argument \code{epsilon} is a threshold whose role is to guarantee
that the algorithm samples invertible matrices when \code{nu > p-1} and
\code{Sigma} is positive definite.
The sampled matrices are theoretically invertible under these conditions,
but due to numerical issues, they are not always invertible when
\code{nu} is close to \code{p-1}, i.e. when \code{nu-p+1} is small.
In this case, the chi-squared distributions involved in the algorithm can
generate zero values or values close to zero, yielding the non-invertibility
of the sampled matrices. These values are replaced with \code{epsilon} if they are
smaller than \code{epsilon}.
}
\note{
A sampled Wishart matrix is always positive semidefinite.
It is positive definite if \code{nu > p-1} and \code{Sigma} is positive
definite, in theory (see Details).

In the noncentral case, i.e. when \code{Theta} is not null, the Ahdida & Alfonsi
algorithm is used if \code{nu} is not an integer and \code{p-1 < nu < 2p-1}, or
if \code{nu = p-1}. The simulations are slower in this case.
}
\examples{
nu <- 4
p <- 3
Sigma <- toeplitz(p:1)
Theta <- diag(p)
Wsims <- rwishart(10000, nu, Sigma, Theta)
dim(Wsims) # 3 3 10000
apply(Wsims, 1:2, mean) # approximately nu*Sigma+Theta
# the epsilon argument:
Wsims_det <- apply(rwishart(10000, nu=p-1+0.001, Sigma), 3, det)
length(which(Wsims_det < .Machine$double.eps))
Wsims_det <- apply(rwishart(10000, nu=p-1+0.001, Sigma, epsilon=1e-8), 3, det)
length(which(Wsims_det < .Machine$double.eps))
}
\references{
A. Ahdida & A. Alfonsi. Exact and high-order discretization schemes
for Wishart processes and their affine extensions.
\emph{The Annals of Applied Probability} \strong{23}, 2013, 1025-1073.
}
