% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{find_maze_refpoint}
\alias{find_maze_refpoint}
\title{Get coordinates for a point in a maze}
\usage{
find_maze_refpoint(point, maze)
}
\arguments{
\item{point}{A description of a relative position in the maze, such as
\code{"topleft"} or \code{"bottomright"}. See Details for all possible
values.}

\item{maze}{A \code{\link{maze}} object.}
}
\value{
A matrix of integers with 2 columns, giving the coordinates of the
  desired point(s). Note that the x-coordinate (column index) comes first, so
  for the corresponding index in the original matrix, these coordinates will
  need to be reversed.
}
\description{
A function that takes a description of a point in a maze and finds the matrix
indices corresponding to that point.
}
\details{
For standard values of \code{point}, this function will identify a "target"
(such as the top left corner of the matrix) and select the point in the maze
that is closest to that target, by Euclidean distance. The standard choices
for \code{point} are: \code{"topleft"}, \code{"top"}, \code{"topright"},
\code{"righttop"}, \code{"right"}, \code{"rightbottom"},
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"},
\code{"leftbottom"}, \code{"left"}, \code{"lefttop"}, and \code{"center"}.
For convenience, there are several redundancies built in; for example,
\code{"topleft"} is identical to \code{"lefttop"}.

In addition to the standard values, there is a complementary set of "matrix"
or "manhattan-like" values, each of which is prepended with an \code{"m"}
(for example, \code{"mtopleft"}). These options select the most extreme value
along one dimension (ie. the highest possible row), fix that value, and then
select the local extreme in the other dimension (column). For example, the
value \code{"mtopleft"} will select the highest possible row in the maze
before selecting the left-most point in that row. Note that this means values
such as \code{"mtopleft"} and \code{"mlefttop"} are not synonymous.

For convenience, if \code{point} is a 2-column matrix or numeric
  vector that can be coerced into a 2-column matrix, it will be returned as
  such, with minor formatting changes to match the usual output. This is so
  that functions which rely on \code{find_maze_refpoint} can use either
  relative descriptions or exact coordinates.
}
\examples{
m <- maze(15,15)
r <- find_maze_refpoint('topright', m)

plot(m, walls = TRUE)
points(r[1], r[2], col = 2, pch = 16)

}
