% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R-utils.R
\name{make_Z}
\alias{make_Z}
\title{Make cross-validation folds.}
\usage{
make_Z(obs, nRuns = 30, frac = 0.1, contiguous = TRUE)
}
\arguments{
\item{obs}{Vector of observations.}

\item{nRuns}{Number of repetitions.}

\item{frac}{Fraction of left-out points. For leave-one-out, use \code{frac = 1}, otherwise use any value less than 1. Default is 0.1 (leave-10\%-out).}

\item{contiguous}{Logical. If \code{TRUE}, the default, the left-out points are made in contiguous blocks; otherwise, they are scattered randomly.}
}
\value{
A list of cross-validation folds
}
\description{
Make a list of cross-validation folds. Each element of the list is a vector of the cross-validation points for one cross-validation run.
}
\examples{
Z <- make_Z(p1Seasonal$Qa, nRuns = 30, frac = 0.25, contiguous = TRUE)
}
