% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{charVecToEdgelist}
\alias{charVecToEdgelist}
\title{Convert characteristic vector to edge list.}
\usage{
charVecToEdgelist(charvec)
}
\arguments{
\item{charvec}{[\code{integer}]
Characteristic vector.}
}
\value{
[\code{matrix}] Edge list.
}
\description{
Convert characteristic vector to edge list.
}
\examples{
# here we generate a random Pruefer-code representing
# a random spanning tree of a graph with n = 10 nodes
pcode = sample(1:10, 8, replace = TRUE)#'
edgelist = charVecToEdgelist(prueferToCharVec(pcode))
}
\seealso{
Other transformation functions: 
\code{\link{edgeListToCharVec}()},
\code{\link{nodelistToEdgelist}()},
\code{\link{permutationToCharVec}()},
\code{\link{permutationToEdgelist}()},
\code{\link{prueferToCharVec}()},
\code{\link{prueferToEdgeList}()}
}
\concept{transformation functions}
