% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{prueferToEdgeList}
\alias{prueferToEdgeList}
\title{Convert Pruefer code to edge list.}
\usage{
prueferToEdgeList(pcode)
}
\arguments{
\item{pcode}{[\code{integer}]
Pruefer code encoding a minimum spanning tree.}
}
\value{
[\code{matrix(2, length(pcode) + 1)}] Edge list.
}
\description{
Convert Pruefer code to edge list.
}
\examples{
# here we generate a random Pruefer-code representing
# a random spanning tree of a graph with n = 10 nodes
pcode = sample(1:10, 8, replace = TRUE)
print(pcode)
edgelist = prueferToEdgeList(pcode)
print(edgelist)
}
\seealso{
Other transformation functions: 
\code{\link{charVecToEdgelist}()},
\code{\link{edgeListToCharVec}()},
\code{\link{nodelistToEdgelist}()},
\code{\link{permutationToCharVec}()},
\code{\link{permutationToEdgelist}()},
\code{\link{prueferToCharVec}()}
}
\concept{transformation functions}
