% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnames.R
\name{keep_fnames}
\alias{keep_fnames}
\alias{drop_fnames}
\title{Filter collection of filenames by name}
\usage{
keep_fnames(x, y, invert = FALSE, ...)

drop_fnames(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{\link{fnames}}, to be filtered.}

\item{y}{An object of class \code{\link{fnames}} or class \code{\link{types}} or a character vector.
This is the filtering criterion.}

\item{invert}{Boolean value. If \code{TRUE}, the elements in \code{y} are excluded rather
than kept (and \code{keep_fnames()} behaves like \code{drop_fnames()})}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{\link{fnames}}.
}
\description{
The functions build a subset of an object of class \code{\link{fnames}} based on a vector
of characters, either including them (with \code{keep_fnames(invert = FALSE)}) or
excluding them (with \code{keep_fnames(invert = FALSE)} or \code{drop_fnames()}).
}
\examples{
all_fnames <- as_fnames(c("file1", "file2", "file3",
                          "file4", "file5", "file6"))

unwanted_fnames <- as_fnames(c("file1", "file4"))
keep_fnames(all_fnames, unwanted_fnames, invert = TRUE)
drop_fnames(all_fnames, unwanted_fnames)

wanted_fnames <- as_fnames(c("file3", "file5"))
keep_fnames(all_fnames, wanted_fnames)
}
