% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{pearsonTest}
\alias{pearsonTest}
\title{Hypothesis Test for Pearson Correlation Coefficient}
\usage{
pearsonTest(
  x,
  y,
  h0 = 0,
  conf.level = 0.95,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{x}{(\code{numeric})\cr one measurement.}

\item{y}{(\code{numeric})\cr another measurement.}

\item{h0}{(\code{numeric})\cr a specified hypothesized value of the difference between
the two correlations, default is 0.}

\item{conf.level}{(\code{numeric})\cr significance level for the returned confidence
interval and hypothesis.}

\item{alternative}{(\code{string})\cr string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".}

\item{...}{other arguments to be passed to \code{\link[=cor.test]{cor.test()}}.}
}
\value{
a named vector contains correlation coefficient (\code{cor}), confidence
interval(\code{lowerci} and \code{upperci}), Z statistic (\code{Z}) and p-value (\code{pval})
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Adjust the \code{cor.test} function so that it can define the specific H0 as per
your request, that is based on Fisher's Z transformation of the correlation.
}
\examples{
x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
y <- c(2.6, 3.1, 2.5, 5.0, 3.6, 4.0, 5.2, 2.8, 3.8)
pearsonTest(x, y, h0 = 0.5, alternative = "greater")
}
\references{
NCSS correlation document
}
\seealso{
\code{\link[=cor.test]{cor.test()}} to see the detailed arguments.
}
