% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasErrorExt.R
\name{MeasErrorExt}
\alias{MeasErrorExt}
\title{Create an External Measurement Error Object}
\usage{
MeasErrorExt(substitute, model)
}
\arguments{
\item{substitute}{a vector containing the error-prone measure}

\item{model}{a fitted linear model of class \link[stats]{lm} or a named
\link[base]{list}. The \link[base]{list} contains a vector named \code{coef}:
the coefficients of the calibration model or measurement error model and an
optional matrix named \code{vcov}: the variance--covariance matrix of the
coefficients}
}
\value{
\code{MeasErrorExt} returns an object of \link[base]{class}
"MeasErrorExt".

An object of class \code{MeasErrorExt} is a list containing the substitute
variable and the fitted calibration model or measurement error model and has
attributes input (the name of the substitute variable) and call (the matched
call).
}
\description{
This function creates an external measurement error object, usually used as
a covariate or the outcome in the \code{formula} argument of
\link[mecor]{mecor} if one wants to correct for the measurement error in that
variable using external data or externally estimated coefficients of the
calibration model (covariate-measurement error) or measurement error model
(outcome-measurement error)
}
\examples{
## measurement error in a outcome:
# external outcome-validation study
data(haemoglobin_ext)
# calibration model
calmod_fit <- lm(capillary ~ venous, data = haemoglobin)
# the external covariate-validation study can be used to correct for the
# measurement error in X_star in the dataset 'icvs', using the fitted
# calibration model
data(haemoglobin)
with (haemoglobin, MeasErrorExt(substitute = capillary,
                                model = calmod_fit))
# identical to:
calmod_coef <- coefficients(calmod_fit)
calmod_vcov <- vcov(calmod_fit)
with (haemoglobin, MeasErrorExt(substitute = capillary,
                                model = list(coef = calmod_coef,
                                             vcov = calmod_vcov)))
# when no external data is available, guesstimations of the coefficients of
# the calibration model can be used instead:
with (haemoglobin, MeasErrorExt(substitute = capillary,
                                model = list(coef = c('(Intercept)' = -7,
                                                      'venous' = 1.1))))
}
\author{
Linda Nab, \email{l.nab@lumc.nl}
}
