% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sodium}
\alias{sodium}
\title{TONE sodium data [outcome-calibration study]}
\format{
A data frame with 1000 rows and 4 variables:
\describe{
  \item{recall}{Sodium intake measured by a 24h recall (mg)}
  \item{diet}{Usual diet or sodium-lowering diet (0 = usual, 1 = sodium-lowering)}
  \item{urinary1}{Sodium intake measured in urine (1st measure, mg)}
  \item{urinary2}{Sodium intake measured in urine (2nd measure, mg)}
}
}
\usage{
sodium
}
\description{
Self-reported sodium intake and urinary sodium in the TONE study, a randomized controlled trial designed to
investigate whether a reduction in sodium intake results in satisfactory blood pressure control.
Two replicate urinary sodium measures were available in 50\% of the subjects included in the trial.
}
\details{
This is a simulated data set inspired by the TONE study <doi: 10.1016/1047-2797(94)00056-y>. A motivating example using the example data can be found here: <doi:10.1002/sim.7011>
}
\examples{
data("sodium", package = "mecor")
}
\references{
Lawrence J Appel, Mark Espeland, Paul K Whelton, Therese Dolecek, Shiriki Kumanyika, William B Applegate, Walter H Ettinger, John B Kostis, Alan C Wilson, Clifton Lacy, and Stephen T Miller. Trial of Nonpharmacologic Intervention in the Elderly (TONE). Design and rationale of a blood pressure control trial. Annals of Epidemiology (1995). <doi: 10.1016/1047-2797(94)00056-y>

Ruth H Keogh, Raymond J Carroll, Janet A Tooze, Sharon I Kirkpatrick, Laurence S Freedman. Statistical issues related to dietary intake as the response variable in intervention trials. Statistics in Medicine (2016). <doi:10.1002/sim.7011>
}
\keyword{datasets}
