% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indometh.R
\docType{data}
\name{indometh}
\alias{indometh}
\title{Cohort Study of the Pharmacokinetics of Intravenous Indomethacin}
\format{
A data frame with 66 observations and 3 variables
\describe{
\item{Subject}{subject id number for each participant; type: character}
\item{time}{Time from initial dose in hours; type: double}
\item{conc}{Concentration of indomethacin in the plasma in micrograms per milliliter' type: double}
}
}
\source{
Kwan, Breault, Umbenhauer, McMahon and Duggan (1976) Kinetics of Indomethacin absorption, elimination, and enterohepatic circulation in man. Pharmacokinetics and Biopharmaceutics. 1976 Jun;4(3):255-80.  doi: 10.1007/BF01063617.
}
\usage{
indometh
}
\description{
Results of a Cohort Study of the Pharmacokinetics of Intravenous Indomethacin, with plasma concentrations over time (\strong{more details} available below the variable definitions). \cr
}
\details{
This data set contains data on 6 healthy volunteer subjects who participated in a pharmacokinetic study of intravenous indomethacin. Indomethacin is an anti-inflammatory and pain-relieving non-steroidal medication. It can be administered by the intravenous, oral, or rectal suppository routes. Some of the indomethacin is excreted in the bile and reabsorbed by the intestine. This phenomenon, called enterohepatic circulation, keeps the drug around longer than would be expected otherwise. \cr
Each subject in Study 1 (intravenous route) received a single 50 mg dose of radioactively labeled indomethacin (^14^-carbon-labeled, with each dose containing 25 microCuries of radioactivity). Subjects received a standard meal (one 8-oz can of Metrecal, 8 oz of whole milk, and one medium-size apple) 30 rain prior to medication and 8 oz of water every 2 hr throughout the waking hours to ensure adequate urine output.\cr
Blood samples were taken at frequent intervals over the first 8 hours after dosing, and the quantity of indomethacin in the plasma (as well as stool and urine) at each time point was measured in micrograms per milliliter. This data set only contains the plasma measurements from Table 1 on page 258 of the manuscript. While this paper was published in 1976 (post-Tuskegee reveal), there is no mention of ethics review, IRB review, or consent of the healthy volunteers. \cr
The abstract from the original manuscript: \cr
There are no discernible quantitative differences in the biotransformation and the excretion of indomethacin following oral, rectal, and intravenous administration of indomethacin-2-^14^C. Approximately 50\% (range 24-115\% for n = 6) of an intravenous dose undergoes enterohepatic circulation. Thus the bioavailability of indomethacin to the systemic circulation may exceed the administered dose. Relative to the intravenous dose, indomethacin is 80 and 100\% bioavailable from suppositories and capsules, respectively. Absorption and/or reabsorption appears to be more rapid and uniform by the rectal route. Recognition of the attributes of biliary recycling also helps to explain the observed variability in apparent plasma half-life, while their neglect requires alternative explanations for anomalies between the disappearance rate from plasma and the corresponding appearance rate in urine.\cr
}
\keyword{datasets}
