globalVariables(".data")

#' @name memery
"_PACKAGE"

#' @import showtext colourpicker shinyBS shinycssloaders
#' @importFrom magrittr %>%
NULL

#' Run memery example app
#'
#' Launch the memery example app in your browser.
#'
#' This example app launches with animated gif support and relevant initial
#' example gif if the magick package is installed. Otherwise, a simplified
#' version of the app that does not provide gif support launches and starting
#' images must be jpg or png.
#'
#' Due to how `meme_gif()` works, gifs will not display in a hosted app, i.e.,
#' on `shinyapps.io`. Memes based on gifs with many frames also take longer to
#' render. By default, the app is set to render any animated gif input into a
#' static meme using only the first frame in the animated gif. If it takes one
#' second to render a single frame, expect it to take about 43 seconds to render
#' the 43-frame example animated gif that comes preloaded in the app. If the user
#' wishes to wait, the input control menu for output frames can be switched from
#' first frame to all frames.
#'
#' While `jpg` and `png` memes will display in a hosted app like on `shinyapps.io`,
#' the impact font will also not likely be available on a given server. For all
#' these reasons this packaged app is not hosted elsewhere. The best and
#' intended experience is to use the app locally via the `memery` package.
#'
#' All ggplot objects that exist in the global environment when the app is
#' launched propagate a selection menu in app for use as inset plots to overlay
#' meme image backgrounds. If there are no ggplot objects in the global
#' environment, one named `memery_testplot()` will be created within the app
#' environment and will appear in the selection menu instead.
#'
#' A meme can be saved from an app by right-clicking on the image in your web
#' browser and selecting the save option just like with any other web images.
#'
#' @export
#'
#' @return nothing is returned; packaged Shiny app is launched interactively in browser.
#'
#' @examples
#' \dontrun{memeApp()}
memeApp <- function(){
  shiny::runApp(system.file("shiny", "memeApp", package = "memery"))
}

.no_magick <- "The `magick` package must be installed to use `meme_gif`."

.check_for_magick <- function(){
  requireNamespace("magick", quietly = TRUE)
}
