% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLUE.R
\name{BLUE_s}
\alias{BLUE_s}
\title{BLUEs of individual location and scale parameters}
\usage{
BLUE_s(X, n, type)
}
\arguments{
\item{X}{a vector of ordered summary statistics}

\item{n}{the sample size}

\item{type}{a character string indicating which type of summary statistics is reported. The options for the \strong{type} argument are: 
\itemize{
   \item "S1" for the sample mean, minimum and maximum values
   \item "S2" for the sample mean, first and third quartiles
   \item "S3" for the sample mean, first and third quartiles, and minimum and maximum values
   \item "tertiles" for tertiles, "quintiles" for quintiles, and "deciles" for deciles
}}
}
\description{
To obtain the best linear unbiased estimator (BLUE) of location and scale parameters based on any set of order statistics (Yang et al., 2018), where the underlying distribution is assumed to be normal.
}
\examples{
X<-c(1,4,10)
n<-30
type<-"S1"
BLUE_s(X,n,type)

X<-c(5,8)
n<-45
type<-"tertiles"
BLUE_s(X,n,type)
}
\references{
Yang X, Hutson AD, and Wang D. (2018). A generalized BLUE approach for combining location and scale information in a meta-analysis (Submitted).
}
