% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SDp_from_CIp}
\alias{SDp_from_CIp}
\title{Pooled Standard Deviation from Confidence Interval}
\usage{
SDp_from_CIp(
  CI_low,
  CI_up,
  n1,
  n2,
  sig_level = 0.05,
  two_sided = TRUE,
  t_dist = TRUE
)
}
\arguments{
\item{CI_low}{lower limit confidence interval}

\item{CI_up}{upper limit confidence interval}

\item{n1}{sample size group 1}

\item{n2}{sample size group 2}

\item{sig_level}{significance level}

\item{two_sided}{whether a two sided test for significance was used}

\item{t_dist}{whether a t distribution has been used to calculate the CI}
}
\value{
Pooled standard deviation
}
\description{
Computes the pooled standard deviation (e.g., standard deviation of an intervention effect) from confidence intervals and sample sizes. According to the Cochrane Handbook (see references), this standard deviation is referred to as the "within-group standard deviation." This method is valid only if the confidence interval is symmetrical around the mean and if either the t-distribution or normal distribution (when "t_dist = FALSE") was used to calculate the confidence interval.
}
\examples{
#lower CI = 0.5, upper CI = 0.7, N1 = 50, N2 = 70
SDp_from_CIp(0.5, 0.7, 50, 70)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_3_obtaining_standard_deviations_from_standard_errors.htm}{Cochrane Handbook}
}
\seealso{
\code{\link[=SD_from_CI]{SD_from_CI()}} for single group standard deviation.
}
