% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.metaRangeSpecies}
\alias{plot.metaRangeSpecies}
\title{Plotting function}
\usage{
\method{plot}{metaRangeSpecies}(x, trait_name, col, main = NULL, ...)
}
\arguments{
\item{x}{\verb{<metaRangeSpecies>} \link{metaRangeSpecies} object.}

\item{trait_name}{\verb{<string>} name of the trait to plot.}

\item{col}{\verb{<character>} colors to use. Defaults to \code{grDevices::hcl.colors()} with
\code{n =50} and a random palette.}

\item{main}{\verb{<string>} optional title of the plot. Will be labeled automatically when NULL.}

\item{...}{additional arguments passed to \link[terra:plot]{terra::plot} or \link[base:plot]{base::plot}.}
}
\value{
\verb{<invisible NULL>}.
}
\description{
Plots the specified trait of a \link{metaRangeSpecies} object.
}
\examples{
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
names(sim_env) <- "env_01"
test_sim <- metaRangeSimulation$new(source_environment = sim_env)
test_sim$add_species("species_01")
test_sim$add_traits("species_01", trait_01 = matrix(1:4, nrow = 2, ncol = 2))
plot(test_sim$species_01, "trait_01")
}
