% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_inf.R
\name{sens_inf}
\alias{sens_inf}
\alias{print.sens_inf}
\alias{summary.sens_inf}
\alias{print.summary.sens_inf}
\title{Decision Inconsistency index for individual studies and leave-one out
sensitivity analysis for inconsistency measures}
\usage{
sens_inf(x)

\method{print}{sens_inf}(x, ...)

\method{summary}{sens_inf}(object, ...)

\method{print}{summary.sens_inf}(x, ...)
}
\arguments{
\item{x}{An R object of class \code{\link{inc}}.}

\item{\dots}{Additional arguments (ignored).}

\item{object}{An R object of class \code{sens_inf}.}
}
\value{
This function generates:
\item{di_stud}{A data frame containing the Decision Inconsistency
  index for each individual primary study.}
\item{di_asi_sens}{A data frame containing results of a
  leave-one-out sensitivity analysis for the Decision Inconsistency
  index and the Across-Studies Inconsistency index.}
}
\description{
Computation of the Decision Inconsistency index for each individual
primary study and leave-one-out sensitivity analysis for the
Decision Inconsistency index and the Across-Studies Inconsistency
index.
}
\details{
Computes the Decision Inconsistency index (DI) for each individual primary 
study and performs a leave-one-out sensitivity analysis for the DI and for 
the Across-Studies Inconsistency index. This function takes, as its
single argument, an object of the class \code{\link{inc}}.
}
\examples{
\donttest{
data(anticoagulation)
inc_anticoagulation <-
  inc(log(anticoagulation), dt1 = 16, dt2 = 31, dt3 = 60,
    br = 0.5, sm = "OR")
sens <- sens_inf(inc_anticoagulation)
sens
}

}
\author{
Bernardo Sousa-Pinto \email{bernardo@med.up.pt}
}
\keyword{print}
